/*
 * Decompiled with CFR 0.152.
 */
package ganymede.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ganymede.io.PrintStreamBuffer;
import ganymede.jupyter.NotebookServicesClient;
import ganymede.notebook.Magic;
import ganymede.server.Channel;
import ganymede.server.Connection;
import ganymede.server.Dispatcher;
import ganymede.server.Message;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.zeromq.ZMQ;

public abstract class Server
extends ScheduledThreadPoolExecutor {
    @Generated
    private static final Logger log = LogManager.getLogger(Server.class);
    protected static final ComparableVersion PROTOCOL_VERSION = new ComparableVersion("5.3");
    private final ZMQ.Context context = ZMQ.context((int)1);
    private final Channel.Heartbeat heartbeat = new Channel.Heartbeat(this);
    private final Channel.Control control = new Control();
    private final Channel.IOPub iopub = new Channel.IOPub(this);
    private final Channel.Stdin stdin = new Stdin();
    private final Channel.Shell shell = new Shell();
    private NotebookServicesClient notebookServicesClient = null;
    private InputStream in = null;
    private PrintStreamBuffer out = null;
    private PrintStreamBuffer err = null;
    private UUID kernelId = null;
    private UUID kernelSessionId = null;
    protected final AtomicInteger execution_count = new AtomicInteger(0);
    protected transient Message request = null;

    protected Server() {
        super(16);
        try {
            this.notebookServicesClient = new NotebookServicesClient();
        }
        catch (Exception exception) {
            log.debug("{}", (Throwable)exception);
        }
    }

    public void bind(String path) throws IOException {
        this.bind(new File(path));
    }

    protected void bind(File file) throws IOException {
        Connection connection = Connection.parse(file);
        boolean starting = this.getKernelId() == null;
        this.setKernelId(connection.getKernelId());
        log.info("Kernel {}", (Object)this.getKernelId());
        connection.connect(this.shell, this.control, this.iopub, this.stdin, this.heartbeat);
        log.info("Connected to {}", (Object)connection.getNode().toPrettyString());
        if (starting) {
            this.iopub.pub(Message.status(Message.status.starting, null));
        }
    }

    protected void restart() throws Exception {
        this.in = new ByteArrayInputStream(new byte[0]);
        this.out = new PrintStreamBuffer();
        this.err = new PrintStreamBuffer();
    }

    protected abstract ObjectNode getKernelInfo();

    protected abstract void execute(String var1) throws Exception;

    protected abstract String evaluate(String var1) throws Exception;

    protected abstract Magic.completeness isComplete(String var1) throws Exception;

    protected abstract void interrupt();

    protected void pub(Message message) {
        this.iopub.pub(message);
    }

    protected Message stamp(Message message) {
        if (message.version() == null) {
            message.version(PROTOCOL_VERSION.toString());
        }
        if (message.session() == null) {
            message.session(this.getKernelSessionId().toString());
        }
        return message.timestamp();
    }

    @Generated
    public ZMQ.Context getContext() {
        return this.context;
    }

    @Generated
    public Channel.Heartbeat getHeartbeat() {
        return this.heartbeat;
    }

    @Generated
    public Channel.Control getControl() {
        return this.control;
    }

    @Generated
    public Channel.IOPub getIopub() {
        return this.iopub;
    }

    @Generated
    public Channel.Stdin getStdin() {
        return this.stdin;
    }

    @Generated
    public Channel.Shell getShell() {
        return this.shell;
    }

    @Generated
    public NotebookServicesClient getNotebookServicesClient() {
        return this.notebookServicesClient;
    }

    @Generated
    public InputStream getIn() {
        return this.in;
    }

    @Generated
    public PrintStreamBuffer getOut() {
        return this.out;
    }

    @Generated
    public PrintStreamBuffer getErr() {
        return this.err;
    }

    @Generated
    public UUID getKernelId() {
        return this.kernelId;
    }

    @Generated
    public UUID getKernelSessionId() {
        return this.kernelSessionId;
    }

    @Generated
    protected void setNotebookServicesClient(NotebookServicesClient notebookServicesClient) {
        this.notebookServicesClient = notebookServicesClient;
    }

    @Generated
    protected void setIn(InputStream in) {
        this.in = in;
    }

    @Generated
    protected void setOut(PrintStreamBuffer out) {
        this.out = out;
    }

    @Generated
    protected void setErr(PrintStreamBuffer err) {
        this.err = err;
    }

    @Generated
    protected void setKernelId(UUID kernelId) {
        this.kernelId = kernelId;
    }

    @Generated
    protected void setKernelSessionId(UUID kernelSessionId) {
        this.kernelSessionId = kernelSessionId;
    }

    private class Shell
    extends Channel.Shell {
        public Shell() {
            super(Server.this, Server.this.iopub, Server.this.stdin);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatch(Dispatcher dispatcher, ZMQ.Socket socket, Message message) {
            if (message.isRequest()) {
                try {
                    Server.this.request = message;
                    super.dispatch(dispatcher, socket, Server.this.request);
                }
                finally {
                    Server.this.request = null;
                }
            } else {
                log.warn("Ignoring non-request {}", (Object)message.msg_type());
            }
        }

        private void kernel_info(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            reply.content().setAll(Server.this.getKernelInfo());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            String code = request.content().at("/code").asText();
            boolean silent = request.content().at("/silent").asBoolean();
            boolean store_history = request.content().at("/store_history").asBoolean();
            JsonNode user_expressions = request.content().at("/user_expressions");
            boolean allow_stdin = request.content().at("/allow_stdin").asBoolean();
            boolean stop_on_error = request.content().at("/stop_on_error").asBoolean();
            try {
                if (!code.isEmpty()) {
                    if (!silent && store_history) {
                        Server.this.execution_count.incrementAndGet();
                        Server.this.iopub.pub(request.execute_input(code, Server.this.execution_count.intValue()));
                    }
                    Server.this.execute(code);
                }
            }
            catch (Throwable throwable) {
                reply.status(throwable, code);
            }
            finally {
                reply.content().put("execution_count", Server.this.execution_count.intValue());
                if (reply.content().get("status").asText().equals("ok")) {
                    reply.content().withArray("payload");
                    JsonNode in = request.content().at("/user_expressions");
                    Iterator iterator = in.fields();
                    ObjectNode out = reply.content().with("user_expressions");
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        String name = (String)entry.getKey();
                        String expression = ((JsonNode)entry.getValue()).asText();
                        try {
                            out.put(name, String.valueOf(Server.this.evaluate(expression)));
                        }
                        catch (Throwable throwable) {
                            out.set(name, (JsonNode)Message.content(throwable, expression));
                        }
                    }
                }
                String stdout = Server.this.out.toString();
                String stderr = Server.this.err.toString();
                Server.this.out.reset();
                Server.this.err.reset();
                if (!silent) {
                    if (!stdout.isEmpty()) {
                        Server.this.iopub.pub(request.stream(Message.stream.stdout, stdout));
                    }
                    if (!stderr.isEmpty()) {
                        Server.this.iopub.pub(request.stream(Message.stream.stderr, stderr));
                    }
                }
            }
        }

        private void inspect(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            String code = request.content().at("/code").asText();
            int cursor_pos = request.content().at("/cursor_pos").asInt();
            int detail_level = request.content().at("/detail_level").asInt();
            throw new UnsupportedOperationException();
        }

        private void complete(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            String code = request.content().at("/code").asText();
            int cursor_pos = request.content().at("/cursor_pos").asInt();
            throw new UnsupportedOperationException();
        }

        private void history(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            boolean output = request.content().at("/output").asBoolean();
            boolean raw = request.content().at("/raw").asBoolean();
            String hist_access_type = request.content().at("/hist_access_type").asText();
            int session = request.content().at("/session").asInt();
            int start = request.content().at("/start").asInt();
            int stop = request.content().at("/stop").asInt();
            int n = request.content().at("/n").asInt();
            String pattern = request.content().at("/pattern").asText();
            boolean unique = request.content().at("/unique").asBoolean();
            throw new UnsupportedOperationException();
        }

        private void is_complete(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            String code = request.content().at("/code").asText();
            reply.status(Server.this.isComplete(code));
        }

        @Deprecated(since="5.1")
        private void connect(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            reply.content().setAll(dispatcher.getConnection().getNode());
        }

        private void comm_info(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            ObjectNode comms = reply.content().with("comms");
            if (request.content().hasNonNull("target_name")) {
                String target_name = request.content().at("/target_name").asText();
                Iterator iterator = comms.fields();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    JsonNode dict = (JsonNode)entry.getValue();
                    if (!dict.isObject()) continue;
                    ((ObjectNode)dict).retain(new String[]{target_name});
                    if (!dict.isEmpty()) continue;
                    iterator.remove();
                }
            }
        }

        @Override
        @Generated
        public String toString() {
            return "Server.Shell()";
        }
    }

    private class Stdin
    extends Channel.Stdin {
        public Stdin() {
            super(Server.this);
        }

        @Override
        protected void dispatch(Dispatcher dispatcher, ZMQ.Socket socket, Message message) {
            if (message.isReply()) {
                log.warn("Ignoring {}", (Object)message.msg_type());
            } else {
                log.warn("Ignoring non-reply {}", (Object)message.msg_type());
            }
        }

        @Override
        @Generated
        public String toString() {
            return "Server.Stdin()";
        }
    }

    private class Control
    extends Channel.Control {
        public Control() {
            super(Server.this);
        }

        @Override
        protected void dispatch(Dispatcher dispatcher, ZMQ.Socket socket, Message message) {
            if (message.isRequest()) {
                super.dispatch(dispatcher, socket, message);
            } else {
                log.warn("Ignoring non-request {}", (Object)message.msg_type());
            }
        }

        private void shutdown(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            boolean restart = request.content().at("/restart").asBoolean();
            reply.content().put("restart", restart);
            if (restart) {
                Server.this.restart();
            } else {
                Server.this.shutdown();
            }
        }

        private void interrupt(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            Server.this.interrupt();
        }

        private void debug(Dispatcher dispatcher, Message request, Message reply) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        @Generated
        public String toString() {
            return "Server.Control()";
        }
    }
}

