/*
 * Decompiled with CFR 0.152.
 */
package ganymede.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ganymede.io.PrintStreamBuffer;
import ganymede.notebook.Magic;
import ganymede.notebook.Renderer;
import ganymede.server.Connection;
import ganymede.server.HMACDigester;
import ganymede.util.ObjectMappers;
import java.beans.ConstructorProperties;
import java.io.PrintStream;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeromq.ZMQ;
import org.zeromq.util.ZData;

public class Message {
    @Generated
    private static final Logger log = LogManager.getLogger(Message.class);
    private static final String DELIMITER_STRING = "<IDS|MSG>";
    private static final byte[] DELIMITER_BYTES = "<IDS|MSG>".getBytes(ZMQ.CHARSET);
    private static final ZData DELIMITER_ZDATA = new ZData(DELIMITER_BYTES);
    private static final StackWalker WALKER = StackWalker.getInstance();
    private final Connection connection;
    protected final List<byte[]> envelope = new LinkedList<byte[]>();
    protected ObjectNode header = new ObjectNode(JsonNodeFactory.instance);
    protected ObjectNode parentHeader = new ObjectNode(JsonNodeFactory.instance);
    protected ObjectNode metadata = new ObjectNode(JsonNodeFactory.instance);
    protected ObjectNode content = new ObjectNode(JsonNodeFactory.instance);
    protected final List<byte[]> buffers = new LinkedList<byte[]>();

    public String msg_id() {
        JsonNode node = this.header().get(Message.getCallingMethodName(1));
        return this.asText(node);
    }

    public Message msg_id(String value) {
        this.header().put(Message.getCallingMethodName(1), value);
        return this;
    }

    public String msg_type() {
        JsonNode node = this.header().get(Message.getCallingMethodName(1));
        return this.asText(node);
    }

    public Message msg_type(String value) {
        this.header().put(Message.getCallingMethodName(1), value);
        return this;
    }

    public String session() {
        JsonNode node = this.header().get(Message.getCallingMethodName(1));
        return this.asText(node);
    }

    public Message session(String value) {
        this.header().put(Message.getCallingMethodName(1), value);
        return this;
    }

    public String username() {
        JsonNode node = this.header().get(Message.getCallingMethodName(1));
        return this.asText(node);
    }

    public Message username(String value) {
        this.header().put(Message.getCallingMethodName(1), value);
        return this;
    }

    public String date() {
        JsonNode node = this.header().get(Message.getCallingMethodName(1));
        return this.asText(node);
    }

    public Message date(String value) {
        this.header().put(Message.getCallingMethodName(1), value);
        return this;
    }

    public String version() {
        JsonNode node = this.header().get(Message.getCallingMethodName(1));
        return this.asText(node);
    }

    public Message version(String value) {
        this.header().put(Message.getCallingMethodName(1), value);
        return this;
    }

    private String asText(JsonNode node) {
        return node != null ? node.asText() : null;
    }

    public String getMessageTypeAction() {
        String action = this.msg_type().toLowerCase();
        int index = action.lastIndexOf("_");
        if (index != -1) {
            action = action.substring(0, index);
        }
        return action;
    }

    public boolean isReply() {
        String type = this.msg_type();
        return type != null && type.toLowerCase().endsWith("_reply");
    }

    public boolean isRequest() {
        String type = this.msg_type();
        return type != null && type.toLowerCase().endsWith("_request");
    }

    public Message status(Throwable throwable, String evalue) {
        this.content().setAll(Message.content(throwable, evalue));
        return this;
    }

    public Message status(Throwable throwable) {
        return this.status(throwable, throwable.getMessage());
    }

    public Message status(Magic.completeness completeness2) {
        this.content().put("status", completeness2.name());
        return this;
    }

    public Message reply() {
        return new Reply(this);
    }

    public Message stream(stream stream2, String text) {
        Pub message = new Pub(Message.getCallingMethodName(1), this);
        message.content().put("name", stream2.name());
        message.content().put("text", text);
        return message;
    }

    public Message execute_input(String code, int execution_count) {
        Pub message = new Pub(Message.getCallingMethodName(1), this);
        message.content().put("code", code);
        message.content().put("execution_count", execution_count);
        return message;
    }

    public Message execute_result(int execution_count, ObjectNode content) {
        Pub message = new Pub(Message.getCallingMethodName(1), this);
        message.content().put("execution_count", execution_count);
        message.content().setAll(content);
        return message;
    }

    public Message execute_result(int execution_count, String stdout) {
        return this.execute_result(execution_count, Message.mime_bundle(stdout, new Object[0]));
    }

    public Message display_data(ObjectNode content) {
        Pub message = new Pub(Message.getCallingMethodName(1), this);
        message.content().setAll(content);
        message.content().with("transient");
        return message;
    }

    public Message display_data(String stdout) {
        return this.display_data(Message.mime_bundle(stdout, new Object[0]));
    }

    public static Message status(status status2, Message request) {
        Pub message = new Pub(Message.getCallingMethodName(1), request);
        message.content().put("execution_state", status2.name());
        return message;
    }

    public Message status(status status2) {
        return Message.status(status2, this);
    }

    public Message timestamp() {
        if (this.date() == null) {
            this.date(ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS).format(DateTimeFormatter.ISO_INSTANT));
        }
        return this;
    }

    public Message copy() {
        return new Copy(this);
    }

    public List<byte[]> serialize(HMACDigester digester) {
        LinkedList<byte[]> frames = new LinkedList<byte[]>();
        frames.addAll(this.envelope());
        frames.add(DELIMITER_BYTES);
        byte[] header = this.serialize((JsonNode)this.header());
        byte[] parentHeader = this.serialize((JsonNode)this.parentHeader());
        byte[] metadata = this.serialize((JsonNode)this.metadata());
        byte[] content = this.serialize((JsonNode)this.content());
        String digest = "";
        if (digester != null) {
            digest = digester.digest(header, parentHeader, metadata, content);
        }
        Collections.addAll(frames, digest.getBytes(ZMQ.CHARSET), header, parentHeader, metadata, content);
        frames.addAll(this.buffers());
        return frames;
    }

    private byte[] serialize(JsonNode node) {
        String string = "{}";
        try {
            string = ObjectMappers.JSON.writeValueAsString((Object)node);
        }
        catch (Exception exception) {
            log.warn("{}", (Throwable)exception);
        }
        return string.getBytes(ZMQ.CHARSET);
    }

    public static Message receive(Connection connection, ZMQ.Socket socket, byte[] frame) {
        LinkedList<byte[]> envelope = new LinkedList<byte[]>();
        while (!DELIMITER_ZDATA.equals(frame)) {
            envelope.add(frame);
            frame = Message.recv(socket);
        }
        byte[] signature = Message.recv(socket);
        byte[] header = Message.recv(socket);
        byte[] parentHeader = Message.recv(socket);
        byte[] metadata = Message.recv(socket);
        byte[] content = Message.recv(socket);
        LinkedList<byte[]> buffers = new LinkedList<byte[]>();
        while (socket.hasReceiveMore()) {
            buffers.add(Message.recv(socket));
        }
        HMACDigester digester = connection.getDigester();
        if (digester != null && !digester.verify(new String(signature, ZMQ.CHARSET), header, parentHeader, metadata, content)) {
            throw new SecurityException("Invalid signature");
        }
        Message message = new Message(connection);
        message.envelope().addAll(envelope);
        message.header().setAll(Message.deserialize(header));
        message.parentHeader().setAll(Message.deserialize(parentHeader));
        message.metadata().setAll(Message.deserialize(metadata));
        message.content().setAll(Message.deserialize(content));
        message.buffers().addAll(buffers);
        return message;
    }

    private static byte[] recv(ZMQ.Socket socket) {
        return Objects.requireNonNull(socket.recv(1));
    }

    private static ObjectNode deserialize(byte[] bytes) {
        ObjectNode value = null;
        try {
            value = (ObjectNode)ObjectMappers.JSON.readTree(new String(bytes, ZMQ.CHARSET));
        }
        catch (Exception exception) {
            log.warn("{}", (Throwable)exception);
        }
        return value;
    }

    public static ObjectNode content(Throwable throwable, String evalue) {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        if (throwable != null || evalue != null) {
            node.put("status", "error");
            node.put("ename", throwable.getClass().getCanonicalName());
            node.put("evalue", evalue);
            ArrayNode array = node.putArray("traceback");
            if (throwable != null) {
                PrintStreamBuffer buffer = new PrintStreamBuffer();
                throwable.printStackTrace((PrintStream)buffer);
                Stream.of(buffer.toString().split("\\R")).forEach(t -> array.add(t));
            }
        } else {
            node.put("status", "ok");
        }
        return node;
    }

    public static ObjectNode mime_bundle(Object object, Object ... alternates) {
        return Renderer.MAP.render(object, alternates);
    }

    private static String getCallingMethodName(int skip) {
        String name = (String)WALKER.walk(t -> t.map(StackWalker.StackFrame::getMethodName).skip(skip).findFirst()).get();
        return name;
    }

    public void send(Connection connection, ZMQ.Socket socket) {
        List<byte[]> list = this.serialize(connection.getDigester());
        Iterator<byte[]> iterator = list.iterator();
        while (iterator.hasNext()) {
            byte[] frame = iterator.next();
            socket.send(frame, iterator.hasNext() ? 2 : 0);
        }
    }

    public ObjectNode asObjectNode() {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.set("header", (JsonNode)this.header);
        node.set("parentHeader", (JsonNode)this.parentHeader);
        node.set("metadata", (JsonNode)this.metadata);
        node.set("content", (JsonNode)this.content);
        return node;
    }

    public String toString() {
        String string = Stream.of(this.envelope().stream().map(ZData::new), Stream.of(DELIMITER_STRING, "DIGEST"), Stream.of(this.header(), this.parentHeader(), this.metadata(), this.content()).map(t -> t.toPrettyString()), this.buffers().stream().map(ZData::new)).flatMap(t -> t).map(Object::toString).collect(Collectors.joining("\n"));
        return string;
    }

    @ConstructorProperties(value={"connection"})
    @Generated
    private Message(Connection connection) {
        this.username(System.getProperty("user.name"));
        this.msg_id(UUID.randomUUID().toString());
        this.connection = connection;
    }

    @Generated
    public Connection connection() {
        return this.connection;
    }

    @Generated
    public List<byte[]> envelope() {
        return this.envelope;
    }

    @Generated
    public ObjectNode header() {
        return this.header;
    }

    @Generated
    public ObjectNode parentHeader() {
        return this.parentHeader;
    }

    @Generated
    public ObjectNode metadata() {
        return this.metadata;
    }

    @Generated
    public ObjectNode content() {
        return this.content;
    }

    @Generated
    public List<byte[]> buffers() {
        return this.buffers;
    }

    @Generated
    public Message header(ObjectNode header) {
        this.header = header;
        return this;
    }

    @Generated
    public Message parentHeader(ObjectNode parentHeader) {
        this.parentHeader = parentHeader;
        return this;
    }

    @Generated
    public Message metadata(ObjectNode metadata) {
        this.metadata = metadata;
        return this;
    }

    @Generated
    public Message content(ObjectNode content) {
        this.content = content;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Connection this$connection = this.connection();
        Connection other$connection = other.connection();
        if (this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection)) {
            return false;
        }
        List<byte[]> this$envelope = this.envelope();
        List<byte[]> other$envelope = other.envelope();
        if (this$envelope == null ? other$envelope != null : !((Object)this$envelope).equals(other$envelope)) {
            return false;
        }
        ObjectNode this$header = this.header();
        ObjectNode other$header = other.header();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        ObjectNode this$parentHeader = this.parentHeader();
        ObjectNode other$parentHeader = other.parentHeader();
        if (this$parentHeader == null ? other$parentHeader != null : !this$parentHeader.equals(other$parentHeader)) {
            return false;
        }
        ObjectNode this$metadata = this.metadata();
        ObjectNode other$metadata = other.metadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        ObjectNode this$content = this.content();
        ObjectNode other$content = other.content();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<byte[]> this$buffers = this.buffers();
        List<byte[]> other$buffers = other.buffers();
        return !(this$buffers == null ? other$buffers != null : !((Object)this$buffers).equals(other$buffers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Connection $connection = this.connection();
        result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
        List<byte[]> $envelope = this.envelope();
        result = result * 59 + ($envelope == null ? 43 : ((Object)$envelope).hashCode());
        ObjectNode $header = this.header();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        ObjectNode $parentHeader = this.parentHeader();
        result = result * 59 + ($parentHeader == null ? 43 : $parentHeader.hashCode());
        ObjectNode $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        ObjectNode $content = this.content();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<byte[]> $buffers = this.buffers();
        result = result * 59 + ($buffers == null ? 43 : ((Object)$buffers).hashCode());
        return result;
    }

    private static class Pub
    extends Child {
        public Pub(String msg_type, Message request) {
            super(msg_type, request);
            UUID kernelId;
            this.envelope().clear();
            String topic = msg_type;
            if (request != null && request.connection != null && (kernelId = request.connection.getKernelId()) != null) {
                topic = String.format("kernel.%s.%s", kernelId, msg_type);
            }
            if (topic != null) {
                this.envelope().add(topic.getBytes(ZMQ.CHARSET));
            }
        }
    }

    private static class Reply
    extends Child {
        public Reply(Message request) {
            super(request.getMessageTypeAction() + "_reply", request);
            if (!request.isRequest()) {
                throw new IllegalStateException("Source message is not a request");
            }
            this.envelope().addAll(request.envelope());
            this.content().setAll(Reply.content(null, null));
            this.buffers().addAll(request.buffers());
        }
    }

    private static abstract class Child
    extends Message {
        protected Child(String msg_type, Message request) {
            super(null);
            if (msg_type != null) {
                this.msg_type(msg_type);
            }
            if (request != null) {
                this.parentHeader().setAll(request.header());
            }
        }
    }

    private static class Copy
    extends Message {
        public Copy(Message message) {
            super(null);
            this.envelope().addAll(message.envelope());
            this.header().setAll(message.header());
            this.parentHeader().setAll(message.parentHeader());
            this.metadata().setAll(message.metadata());
            this.content().setAll(message.content());
            this.buffers().addAll(message.buffers());
        }
    }

    public static enum status {
        starting,
        busy,
        idle;

    }

    public static enum stream {
        stderr,
        stdout;

    }
}

