/*
 * Decompiled with CFR 0.152.
 */
package ganymede.server;

import java.math.BigInteger;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeromq.ZMQ;

public class HMACDigester {
    @Generated
    private static final Logger log = LogManager.getLogger(HMACDigester.class);
    private final Mac mac;

    public HMACDigester(String scheme, String key) {
        Mac mac = null;
        if (key != null && !key.isEmpty()) {
            try {
                mac = Mac.getInstance(scheme.replaceAll("-", ""));
                mac.init(new SecretKeySpec(key.getBytes(ZMQ.CHARSET), scheme));
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
        this.mac = mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String digest(byte[] ... frames) {
        Object digest = "";
        if (this.mac != null) {
            Mac mac = this.mac;
            synchronized (mac) {
                Stream.of(frames).forEach(this.mac::update);
                byte[] bytes = this.mac.doFinal();
                digest = new BigInteger(1, bytes).toString(16);
            }
            int length = 2 * this.mac.getMacLength();
            while (((String)digest).length() < length) {
                digest = "0" + (String)digest;
            }
        }
        return digest;
    }

    public boolean verify(String digest, byte[] ... frames) {
        return digest.equals(this.digest(frames));
    }

    @Generated
    public Mac getMac() {
        return this.mac;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HMACDigester)) {
            return false;
        }
        HMACDigester other = (HMACDigester)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Mac this$mac = this.getMac();
        Mac other$mac = other.getMac();
        return !(this$mac == null ? other$mac != null : !this$mac.equals(other$mac));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HMACDigester;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Mac $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HMACDigester(mac=" + this.getMac() + ")";
    }
}

