/*
 * Decompiled with CFR 0.152.
 */
package ganymede.server;

import ganymede.server.Channel;
import ganymede.server.Connection;
import ganymede.server.HMACDigester;
import ganymede.server.Message;
import ganymede.server.Server;
import java.beans.ConstructorProperties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;

public class Dispatcher
implements Runnable {
    @Generated
    private static final Logger log = LogManager.getLogger(Dispatcher.class);
    @NonNull
    private final Channel channel;
    @NonNull
    private final Connection connection;
    @NonNull
    private final String address;
    private final BlockingQueue<Message> outgoing = new SynchronousQueue<Message>();

    protected void dispatch(ZMQ.Socket socket, byte[] frame) {
        this.getChannel().dispatch(this, socket, frame);
    }

    protected void dispatch(ZMQ.Socket socket, Message message) {
        ((Channel.Protocol)this.getChannel()).dispatch(this, socket, message);
    }

    public void pub(Message message) {
        SocketType type = this.getChannel().getSocketType();
        switch (type) {
            case PUB: {
                try {
                    this.outgoing.put(message);
                }
                catch (InterruptedException exception) {
                    log.warn("{}", (Throwable)exception);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported SocketType: " + type);
            }
        }
    }

    @Override
    public void run() {
        Server server = this.getChannel().getServer();
        ZMQ.Context context = server.getContext();
        HMACDigester digester = this.getConnection().getDigester();
        SocketType type = this.getChannel().getSocketType();
        block16: while (!server.isTerminating()) {
            try {
                ZMQ.Socket socket = context.socket(type);
                try {
                    if (socket.bind(this.getAddress())) {
                        log.info("Bound {} {}", (Object)type, (Object)this.address);
                    } else {
                        log.warn("Could not bind to {}", (Object)this.address);
                    }
                    switch (type) {
                        case REP: 
                        case ROUTER: {
                            ZMQ.Poller poller = context.poller(1);
                            try {
                                poller.register(socket, 1);
                                while (!server.isTerminating()) {
                                    byte[] message;
                                    int events = poller.poll(100L);
                                    if (events <= 0 || !poller.pollin(0) || (message = socket.recv()) == null) continue;
                                    this.dispatch(socket, message);
                                }
                                continue block16;
                            }
                            finally {
                                if (poller == null) continue block16;
                                poller.close();
                                continue block16;
                            }
                        }
                        case PUB: {
                            while (!server.isTerminating()) {
                                Message message = this.outgoing.poll(100L, TimeUnit.MILLISECONDS);
                                if (message == null) continue;
                                this.dispatch(socket, message);
                            }
                            continue block16;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported SocketType: " + type);
                        }
                    }
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                }
            }
            catch (Exception exception) {
                log.warn("{}", (Throwable)exception);
            }
        }
    }

    @ConstructorProperties(value={"channel", "connection", "address"})
    @Generated
    public Dispatcher(@NonNull Channel channel, @NonNull Connection connection, @NonNull String address) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.channel = channel;
        this.connection = connection;
        this.address = address;
    }

    @NonNull
    @Generated
    public Channel getChannel() {
        return this.channel;
    }

    @NonNull
    @Generated
    public Connection getConnection() {
        return this.connection;
    }

    @NonNull
    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public BlockingQueue<Message> getOutgoing() {
        return this.outgoing;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dispatcher)) {
            return false;
        }
        Dispatcher other = (Dispatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        Connection this$connection = this.getConnection();
        Connection other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        BlockingQueue<Message> this$outgoing = this.getOutgoing();
        BlockingQueue<Message> other$outgoing = other.getOutgoing();
        return !(this$outgoing == null ? other$outgoing != null : !this$outgoing.equals(other$outgoing));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dispatcher;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        Connection $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        BlockingQueue<Message> $outgoing = this.getOutgoing();
        result = result * 59 + ($outgoing == null ? 43 : $outgoing.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Dispatcher(channel=" + this.getChannel() + ", connection=" + this.getConnection() + ", address=" + this.getAddress() + ", outgoing=" + this.getOutgoing() + ")";
    }
}

