/*
 * Decompiled with CFR 0.152.
 */
package ganymede.server;

import ball.annotation.CompileTimeCheck;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ganymede.server.Channel;
import ganymede.server.HMACDigester;
import ganymede.util.ObjectMappers;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Connection {
    @Generated
    private static final Logger log = LogManager.getLogger(Connection.class);
    @CompileTimeCheck
    public static final Pattern FILE_NAME_PATTERN = Pattern.compile("(?i)^(kernel-|)(?<kernelId>[^.]+)[.]json$");
    @NonNull
    private final UUID kernelId;
    @NonNull
    private final ObjectNode node;
    @NonNull
    private final HMACDigester digester;

    public static Connection parse(File file) throws IOException {
        UUID kernelId = UUID.randomUUID();
        Matcher matcher = FILE_NAME_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            try {
                kernelId = UUID.fromString(matcher.group("kernelId"));
            }
            catch (Exception exception) {
                log.warn("{}", (Object)exception.getMessage());
            }
        }
        ObjectNode node = (ObjectNode)ObjectMappers.JSON.readTree(file);
        HMACDigester digester = new HMACDigester(node.at("/signature_scheme").asText(), node.at("/key").asText());
        return new Connection(kernelId, node, digester);
    }

    public void connect(Channel.Shell shell, Channel.Control control, Channel.IOPub iopub, Channel.Stdin stdin, Channel.Heartbeat heartbeat) {
        HMACDigester digester = this.getDigester();
        shell.connect(this, this.getAddress("shell_port"));
        control.connect(this, this.getAddress("control_port"));
        iopub.connect(this, this.getAddress("iopub_port"));
        stdin.connect(this, this.getAddress("stdin_port"));
        heartbeat.connect(this, this.getAddress("hb_port"));
    }

    public String getAddress(String portName) {
        String address = String.format("%s://%s:%d", this.node.at("/transport").asText(), this.node.at("/ip").asText(), this.node.at("/" + portName).asInt());
        return address;
    }

    @ConstructorProperties(value={"kernelId", "node", "digester"})
    @Generated
    private Connection(@NonNull UUID kernelId, @NonNull ObjectNode node, @NonNull HMACDigester digester) {
        if (kernelId == null) {
            throw new NullPointerException("kernelId is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (digester == null) {
            throw new NullPointerException("digester is marked non-null but is null");
        }
        this.kernelId = kernelId;
        this.node = node;
        this.digester = digester;
    }

    @NonNull
    @Generated
    public UUID getKernelId() {
        return this.kernelId;
    }

    @NonNull
    @Generated
    public ObjectNode getNode() {
        return this.node;
    }

    @NonNull
    @Generated
    public HMACDigester getDigester() {
        return this.digester;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$kernelId = this.getKernelId();
        UUID other$kernelId = other.getKernelId();
        if (this$kernelId == null ? other$kernelId != null : !((Object)this$kernelId).equals(other$kernelId)) {
            return false;
        }
        ObjectNode this$node = this.getNode();
        ObjectNode other$node = other.getNode();
        if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
            return false;
        }
        HMACDigester this$digester = this.getDigester();
        HMACDigester other$digester = other.getDigester();
        return !(this$digester == null ? other$digester != null : !((Object)this$digester).equals(other$digester));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Connection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $kernelId = this.getKernelId();
        result = result * 59 + ($kernelId == null ? 43 : ((Object)$kernelId).hashCode());
        ObjectNode $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        HMACDigester $digester = this.getDigester();
        result = result * 59 + ($digester == null ? 43 : ((Object)$digester).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Connection(kernelId=" + this.getKernelId() + ", node=" + this.getNode() + ", digester=" + this.getDigester() + ")";
    }
}

