/*
 * Decompiled with CFR 0.152.
 */
package ganymede.server;

import ganymede.server.Connection;
import ganymede.server.Dispatcher;
import ganymede.server.Message;
import ganymede.server.Server;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;

public abstract class Channel {
    @Generated
    private static final Logger log = LogManager.getLogger(Channel.class);
    @NonNull
    private final Server server;
    @NonNull
    private final SocketType socketType;
    private final Queue<Dispatcher> dispatcherQueue = new ConcurrentLinkedQueue<Dispatcher>();

    public void connect(Connection connection, String address) {
        Dispatcher dispatcher = new Dispatcher(this, connection, address);
        this.getDispatcherQueue().add(dispatcher);
        this.getServer().submit(dispatcher);
        this.getServer().setCorePoolSize(Math.max(this.getServer().getActiveCount() + 4, this.getServer().getCorePoolSize()));
    }

    protected abstract void dispatch(Dispatcher var1, ZMQ.Socket var2, byte[] var3);

    protected void send(Dispatcher dispatcher, ZMQ.Socket socket, Message message) {
        this.getServer().stamp(message);
        log.debug("{}\n{}", (Object)dispatcher.getAddress(), (Object)message);
        message.send(dispatcher.getConnection(), socket);
    }

    @ConstructorProperties(value={"server", "socketType"})
    @Generated
    public Channel(@NonNull Server server, @NonNull SocketType socketType) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (socketType == null) {
            throw new NullPointerException("socketType is marked non-null but is null");
        }
        this.server = server;
        this.socketType = socketType;
    }

    @NonNull
    @Generated
    public Server getServer() {
        return this.server;
    }

    @NonNull
    @Generated
    public SocketType getSocketType() {
        return this.socketType;
    }

    @Generated
    public Queue<Dispatcher> getDispatcherQueue() {
        return this.dispatcherQueue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Server this$server = this.getServer();
        Server other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        SocketType this$socketType = this.getSocketType();
        SocketType other$socketType = other.getSocketType();
        if (this$socketType == null ? other$socketType != null : !this$socketType.equals(other$socketType)) {
            return false;
        }
        Queue<Dispatcher> this$dispatcherQueue = this.getDispatcherQueue();
        Queue<Dispatcher> other$dispatcherQueue = other.getDispatcherQueue();
        return !(this$dispatcherQueue == null ? other$dispatcherQueue != null : !this$dispatcherQueue.equals(other$dispatcherQueue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Channel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Server $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        SocketType $socketType = this.getSocketType();
        result = result * 59 + ($socketType == null ? 43 : $socketType.hashCode());
        Queue<Dispatcher> $dispatcherQueue = this.getDispatcherQueue();
        result = result * 59 + ($dispatcherQueue == null ? 43 : $dispatcherQueue.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Channel(server=" + this.getServer() + ", socketType=" + this.getSocketType() + ", dispatcherQueue=" + this.getDispatcherQueue() + ")";
    }

    public static abstract class Shell
    extends Control {
        @Generated
        private static final Logger log = LogManager.getLogger(Shell.class);
        private final IOPub iopub;
        private final Stdin stdin;

        protected Shell(Server server, IOPub iopub, Stdin stdin) {
            super(server);
            this.iopub = iopub;
            this.stdin = stdin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatch(Dispatcher dispatcher, ZMQ.Socket socket, Message message) {
            try {
                this.iopub.pub(message.status(Message.status.busy));
                super.dispatch(dispatcher, socket, message);
            }
            finally {
                this.iopub.pub(message.status(Message.status.idle));
            }
        }

        @Override
        @Generated
        public String toString() {
            return "Channel.Shell(iopub=" + this.iopub + ", stdin=" + this.stdin + ")";
        }
    }

    public static abstract class Stdin
    extends Protocol {
        @Generated
        private static final Logger log = LogManager.getLogger(Stdin.class);

        protected Stdin(Server server) {
            super(server, SocketType.ROUTER);
        }

        @Override
        @Generated
        public String toString() {
            return "Channel.Stdin()";
        }
    }

    public static class IOPub
    extends Protocol {
        @Generated
        private static final Logger log = LogManager.getLogger(IOPub.class);

        public IOPub(Server server) {
            super(server, SocketType.PUB);
        }

        public void pub(Message message) {
            this.getDispatcherQueue().forEach(t -> t.pub(message));
        }

        @Override
        protected void dispatch(Dispatcher dispatcher, ZMQ.Socket socket, byte[] frame) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void dispatch(Dispatcher dispatcher, ZMQ.Socket socket, Message message) {
            this.send(dispatcher, socket, message);
        }

        @Override
        @Generated
        public String toString() {
            return "Channel.IOPub()";
        }
    }

    public static abstract class Control
    extends Protocol {
        @Generated
        private static final Logger log = LogManager.getLogger(Control.class);
        private static final Method PROTOTYPE = PROTOTYPE.class.getDeclaredMethods()[0];

        protected Control(Server server) {
            super(server, SocketType.ROUTER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dispatch(Dispatcher dispatcher, ZMQ.Socket socket, Message message) {
            String action = message.getMessageTypeAction();
            if (action != null) {
                Message reply = message.reply();
                try {
                    Method method = this.getClass().getDeclaredMethod(action, PROTOTYPE.getParameterTypes());
                    method.setAccessible(true);
                    method.invoke((Object)this, dispatcher, message, reply);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    reply.status(throwable);
                }
                finally {
                    if (reply != null) {
                        this.send(dispatcher, socket, reply);
                    }
                }
            } else {
                log.warn("Could not determine action from {}", (Object)message.header());
            }
        }

        @Override
        @Generated
        public String toString() {
            return "Channel.Control()";
        }

        static {
            PROTOTYPE.setAccessible(true);
        }

        private static interface PROTOTYPE {
            public void action(Dispatcher var1, Message var2, Message var3) throws Exception;
        }
    }

    public static abstract class Protocol
    extends Channel {
        @Generated
        private static final Logger log = LogManager.getLogger(Protocol.class);

        public Protocol(Server server, SocketType type) {
            super(server, type);
        }

        protected abstract void dispatch(Dispatcher var1, ZMQ.Socket var2, Message var3);

        @Override
        protected void dispatch(Dispatcher dispatcher, ZMQ.Socket socket, byte[] frame) {
            try {
                Message message = Message.receive(dispatcher.getConnection(), socket, frame);
                log.debug("{}\n{}", (Object)dispatcher.getAddress(), (Object)message);
                this.dispatch(dispatcher, socket, message);
            }
            catch (Exception exception) {
                log.warn("{}", (Throwable)exception);
            }
        }

        @Override
        @Generated
        public String toString() {
            return "Channel.Protocol()";
        }
    }

    public static class Heartbeat
    extends Channel {
        @Generated
        private static final Logger log = LogManager.getLogger(Heartbeat.class);

        public Heartbeat(Server server) {
            super(server, SocketType.REP);
        }

        @Override
        protected void dispatch(Dispatcher dispatcher, ZMQ.Socket socket, byte[] frame) {
            socket.send(frame);
        }

        @Override
        @Generated
        public String toString() {
            return "Channel.Heartbeat()";
        }
    }
}

