/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.renderer;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ganymede.notebook.AbstractRenderer;
import ganymede.notebook.ForClass;
import ganymede.notebook.Renderer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

@ServiceProviderFor(value={Renderer.class})
@ForClass(value=Output.class)
public class ThymeleafRenderer
extends AbstractRenderer {
    private static final StringTemplateResolver RESOLVER = new StringTemplateResolver();
    private static final TemplateEngine ENGINE = new TemplateEngine();

    public static Output process(String template, String mode, Map<String, Object> map) {
        RESOLVER.setTemplateMode(mode);
        return new Output(RESOLVER.getTemplateMode(), ENGINE.process(template, (IContext)new Context(null, map)));
    }

    public static Output process(Class<?> type, String name, String mode, Map<String, Object> map) {
        return ThymeleafRenderer.process(ThymeleafRenderer.getResourceAsString(type, name), mode, map);
    }

    public void renderTo(ObjectNode bundle, Object object) {
        Output output = (Output)object;
        String string = output.getOutput();
        String mimeType = "text/plain";
        switch (output.getTemplateMode()) {
            case CSS: {
                mimeType = "text/css";
                break;
            }
            case HTML: 
            case HTML5: 
            case LEGACYHTML5: 
            case VALIDXHTML: 
            case XHTML: {
                mimeType = "text/html";
                break;
            }
            case JAVASCRIPT: {
                mimeType = "text/javascript";
                break;
            }
            case VALIDXML: 
            case XML: {
                mimeType = "text/xml";
                break;
            }
        }
        if (!bundle.with("data").has(mimeType)) {
            bundle.with("data").put(mimeType, string);
        }
    }

    private static String getResourceAsString(Class<?> type, String name) {
        String string;
        block8: {
            InputStream in = new ClassPathResource(name, type).getInputStream();
            try {
                string = StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new ExceptionInInitializerError(exception);
                }
            }
            in.close();
        }
        return string;
    }

    @Generated
    public ThymeleafRenderer() {
    }

    @Generated
    public String toString() {
        return "ThymeleafRenderer()";
    }

    static {
        ENGINE.setTemplateResolver((ITemplateResolver)RESOLVER);
        ENGINE.addDialect((IDialect)new Java8TimeDialect());
    }

    public static class Output {
        private final TemplateMode templateMode;
        private final String output;

        @ConstructorProperties(value={"templateMode", "output"})
        @Generated
        public Output(TemplateMode templateMode, String output) {
            this.templateMode = templateMode;
            this.output = output;
        }

        @Generated
        public TemplateMode getTemplateMode() {
            return this.templateMode;
        }

        @Generated
        public String getOutput() {
            return this.output;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TemplateMode this$templateMode = this.getTemplateMode();
            TemplateMode other$templateMode = other.getTemplateMode();
            if (this$templateMode == null ? other$templateMode != null : !this$templateMode.equals(other$templateMode)) {
                return false;
            }
            String this$output = this.getOutput();
            String other$output = other.getOutput();
            return !(this$output == null ? other$output != null : !this$output.equals(other$output));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Output;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TemplateMode $templateMode = this.getTemplateMode();
            result = result * 59 + ($templateMode == null ? 43 : $templateMode.hashCode());
            String $output = this.getOutput();
            result = result * 59 + ($output == null ? 43 : $output.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ThymeleafRenderer.Output(templateMode=" + this.getTemplateMode() + ", output=" + this.getOutput() + ")";
        }
    }
}

