/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.renderer;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ganymede.notebook.AbstractRenderer;
import ganymede.notebook.ForClassName;
import ganymede.notebook.Renderer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import lombok.Generated;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.string.DataFramePrinter;
import tech.tablesaw.table.Relation;

@ServiceProviderFor(value={Renderer.class})
@ForClassName(value="tech.tablesaw.api.Table")
public class TablesawTableRenderer
extends AbstractRenderer {
    public Optional<TablesawTableRenderer> instance() {
        return Optional.ofNullable(this.getRenderType()).map(t -> new Impl());
    }

    public void renderTo(ObjectNode bundle, Object object) {
        throw new IllegalStateException();
    }

    @Generated
    public TablesawTableRenderer() {
    }

    @Generated
    public String toString() {
        return "TablesawTableRenderer()";
    }

    private class Impl
    extends TablesawTableRenderer {
        @Override
        public void renderTo(ObjectNode bundle, Object object) {
            Table table = (Table)object;
            if (!bundle.with("data").has("text/html")) {
                try {
                    if (this.hasWriterForExtension("html")) {
                        bundle.with("data").put("text/html", table.write().toString("html"));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
            if (table != null) {
                String string = "";
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    new DataFramePrinter(Integer.MAX_VALUE, (OutputStream)out).print((Relation)table);
                    string = new String(out.toByteArray());
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                this.renderers.renderTo(bundle, (Object)string, new Object[0]);
            }
        }

        private boolean hasWriterForExtension(String extension) {
            return Table.defaultWriterRegistry.getWriterForExtension(extension) != null;
        }

        @Generated
        public Impl() {
        }

        @Override
        @Generated
        public String toString() {
            return "TablesawTableRenderer.Impl()";
        }
    }
}

