/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.renderer;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ganymede.notebook.AbstractRenderer;
import ganymede.notebook.ForClassName;
import ganymede.notebook.Renderer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;

@ServiceProviderFor(value={Renderer.class})
@ForClassName(value="org.jfree.chart.JFreeChart")
public class JFreeChartRenderer
extends AbstractRenderer {
    public Optional<JFreeChartRenderer> instance() {
        return Optional.ofNullable(this.getRenderType()).map(t -> new Impl());
    }

    public void renderTo(ObjectNode bundle, Object object) {
        throw new IllegalStateException();
    }

    @Generated
    public JFreeChartRenderer() {
    }

    @Generated
    public String toString() {
        return "JFreeChartRenderer()";
    }

    private class Impl
    extends JFreeChartRenderer {
        @Override
        public Optional<JFreeChartRenderer> instance() {
            return Optional.of(this);
        }

        @Override
        public void renderTo(ObjectNode bundle, Object object) {
            block12: {
                JFreeChart chart = (JFreeChart)object;
                int width = 800;
                int height = 600;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                    ChartUtils.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
                    byte[] image = out.toByteArray();
                    this.renderers.renderTo(bundle, (Object)image, new Object[0]);
                    if (bundle.with("data").has("text/html")) break block12;
                    StringWriter html = new StringWriter();
                    String name = UUID.randomUUID().toString();
                    String mimeType = (String)bundle.with("metadata").fieldNames().next();
                    String base64 = bundle.with("data").get(mimeType).asText();
                    try (PrintWriter writer = new PrintWriter(html);){
                        writer.format("<img usemap=\"#%s\" src=\"data:%s;base64,%s\"/>\n", name, mimeType, base64);
                        ChartUtils.writeImageMap((PrintWriter)writer, (String)name, (ChartRenderingInfo)info, (boolean)false);
                    }
                    bundle.with("data").put("text/html", html.toString());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }
        }

        @Generated
        public Impl() {
        }

        @Override
        @Generated
        public String toString() {
            return "JFreeChartRenderer.Impl()";
        }
    }
}

