/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.renderer;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ganymede.notebook.AbstractRenderer;
import ganymede.notebook.ForClass;
import ganymede.notebook.Renderer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import lombok.Generated;

@ServiceProviderFor(value={Renderer.class})
@ForClass(value=byte[].class)
public class ImageRenderer
extends AbstractRenderer {
    public void renderTo(ObjectNode bundle, Object object) {
        byte[] bytes = (byte[])object;
        try (ImageInputStream in = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));){
            ImageReader reader = ImageIO.getImageReaders(in).next();
            reader.setInput(in);
            String mimeType = reader.getOriginatingProvider().getMIMETypes()[0];
            if (!bundle.with("data").has(mimeType)) {
                bundle.with("data").put(mimeType, BASE64_ENCODER.encodeToString(bytes));
                ObjectNode metadata = bundle.with("metadata").with(mimeType);
                metadata.put("height", reader.getHeight(0));
                metadata.put("width", reader.getWidth(0));
            }
        }
        catch (IOException exception) {
            exception.printStackTrace(System.err);
        }
    }

    @Generated
    public ImageRenderer() {
    }

    @Generated
    public String toString() {
        return "ImageRenderer()";
    }
}

