/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.magic;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.databind.JsonNode;
import ganymede.notebook.AbstractPropertiesMagic;
import ganymede.notebook.Description;
import ganymede.notebook.Magic;
import ganymede.notebook.MagicNames;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import picocli.CommandLine;

@ServiceProviderFor(value={Magic.class})
@MagicNames(value={"spark-session"})
@Description(value="Configure and start a Spark session")
public class SparkSession
extends AbstractPropertiesMagic {
    @Generated
    private static final Logger log = LogManager.getLogger(SparkSession.class);

    public void execute(String line0, String code, JsonNode metadata) throws Exception {
        try {
            String[] argv = Magic.getCellMagicCommand((String)line0);
            Arguments arguments = new Arguments();
            this.parse(argv, arguments);
            SparkConf config = new SparkConf();
            this.compile(code).entrySet().stream().forEach(t -> config.set(t.getKey().toString(), String.valueOf(t.getValue())));
            if (arguments.getMaster() != null) {
                config.setMaster(arguments.getMaster());
            }
            if (arguments.getAppName() != null) {
                config.setAppName(arguments.getAppName());
            }
            SparkSession.Builder builder = org.apache.spark.sql.SparkSession.builder().config(config);
            if (arguments.isEnableHiveIfAvailable()) {
                try {
                    builder.enableHiveSupport();
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            org.apache.spark.sql.SparkSession session = builder.getOrCreate();
            if (org.apache.spark.sql.SparkSession.getDefaultSession().isEmpty()) {
                org.apache.spark.sql.SparkSession.setDefaultSession((org.apache.spark.sql.SparkSession)session);
            }
            org.apache.spark.sql.SparkSession.setActiveSession((org.apache.spark.sql.SparkSession)session);
            this.context.display((Object)session);
        }
        catch (CommandLine.ParameterException exception) {
            System.err.println(exception.getMessage());
            System.err.println();
            exception.getCommandLine().usage(System.err);
        }
        catch (NoClassDefFoundError error) {
            System.err.format("Apache Spark not found on classpath: %s:\n", error);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    public String getUsage() {
        return this.getUsage(new Arguments());
    }

    @Generated
    public SparkSession() {
    }

    @Generated
    public String toString() {
        return "SparkSession()";
    }

    @CommandLine.Command
    private class Arguments {
        @CommandLine.Parameters(description={"Spark master"}, index="0", arity="0..1")
        private String master = null;
        @CommandLine.Parameters(description={"Spark appName"}, index="1", arity="0..1", defaultValue="root")
        private String appName = null;
        @CommandLine.Option(names={"--no-enable-hive-if-available"}, negatable=true, description={"Enable Hive if available.  true by default"})
        private boolean enableHiveIfAvailable = true;

        @Generated
        public Arguments() {
        }

        @Generated
        public String getMaster() {
            return this.master;
        }

        @Generated
        public String getAppName() {
            return this.appName;
        }

        @Generated
        public boolean isEnableHiveIfAvailable() {
            return this.enableHiveIfAvailable;
        }

        @Generated
        public void setMaster(String master) {
            this.master = master;
        }

        @Generated
        public void setAppName(String appName) {
            this.appName = appName;
        }

        @Generated
        public void setEnableHiveIfAvailable(boolean enableHiveIfAvailable) {
            this.enableHiveIfAvailable = enableHiveIfAvailable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments other = (Arguments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnableHiveIfAvailable() != other.isEnableHiveIfAvailable()) {
                return false;
            }
            String this$master = this.getMaster();
            String other$master = other.getMaster();
            if (this$master == null ? other$master != null : !this$master.equals(other$master)) {
                return false;
            }
            String this$appName = this.getAppName();
            String other$appName = other.getAppName();
            return !(this$appName == null ? other$appName != null : !this$appName.equals(other$appName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Arguments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableHiveIfAvailable() ? 79 : 97);
            String $master = this.getMaster();
            result = result * 59 + ($master == null ? 43 : $master.hashCode());
            String $appName = this.getAppName();
            result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SparkSession.Arguments(master=" + this.getMaster() + ", appName=" + this.getAppName() + ", enableHiveIfAvailable=" + this.isEnableHiveIfAvailable() + ")";
        }
    }
}

