/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.magic;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.databind.JsonNode;
import ganymede.notebook.AbstractMagic;
import ganymede.notebook.Description;
import ganymede.notebook.Magic;
import ganymede.notebook.MagicNames;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ServiceProviderFor(value={Magic.class})
@MagicNames(value={"!", "script"})
@Description(value="Execute script with the argument command")
public class Script
extends AbstractMagic {
    @Generated
    private static final Logger log = LogManager.getLogger(Script.class);

    public void execute(String line0, String code, JsonNode metadata) throws Exception {
        String[] argv = (String[])Stream.of(Magic.getCellMagicCommand((String)line0)).skip(1L).toArray(String[]::new);
        Process process = new ProcessBuilder(argv).redirectInput(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.PIPE).start();
        try (InputStream in = process.getInputStream();){
            try (OutputStream out = process.getOutputStream();){
                out.write(code.getBytes(StandardCharsets.UTF_8));
            }
            in.transferTo(System.out);
            int n = process.waitFor();
        }
    }

    protected String rewrite(String line0) {
        return String.format("%s%s %s", "%%", "script", line0.substring("%%".length()));
    }

    @Generated
    public Script() {
    }

    @Generated
    public String toString() {
        return "Script()";
    }
}

