/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.magic;

import ball.annotation.ServiceProviderFor;
import ganymede.notebook.AbstractScriptEngineMagic;
import ganymede.notebook.Description;
import ganymede.notebook.Magic;
import ganymede.notebook.NotebookContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import scala.tools.nsc.Settings;

@ServiceProviderFor(value={Magic.class})
@Description(value="Execute code in scala REPL")
public class Scala
extends AbstractScriptEngineMagic {
    @Generated
    private static final Logger log = LogManager.getLogger(Scala.class);
    private boolean isScriptedScriptEngine = false;

    private Object eval(ScriptEngine engine, ClassPathResource resource) throws IOException, ScriptException {
        Object object = null;
        try (InputStream in = resource.getInputStream();){
            object = this.eval(engine, in);
        }
        return object;
    }

    private Object eval(ScriptEngine engine, InputStream in) throws IOException, ScriptException {
        Object object = null;
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            Object script = engine.getClass().getMethod("compile", Reader.class).invoke((Object)engine, reader);
            object = script.getClass().getMethod("eval", ScriptContext.class).invoke(script, this.context.context);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof ScriptException) {
                throw (ScriptException)cause;
            }
            throw new IllegalStateException(exception);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
        return object;
    }

    private Object eval(ScriptEngine engine, String code) throws ScriptException {
        Object object = null;
        try {
            Object script = engine.getClass().getMethod("compile", String.class).invoke((Object)engine, code);
            object = script.getClass().getMethod("eval", ScriptContext.class).invoke(script, this.context.context);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof ScriptException) {
                throw (ScriptException)cause;
            }
            throw new IllegalStateException(exception);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
        return object;
    }

    protected ScriptEngine engine() {
        if (this.engine == null) {
            Class<ScriptEngine> type = null;
            try {
                type = Class.forName("scala.tools.nsc.interpreter.Scripted", false, this.context.getClassLoader()).asSubclass(ScriptEngine.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            boolean bl = this.isScriptedScriptEngine = type != null;
            if (this.isScriptedScriptEngine) {
                try {
                    ScriptEngineManager manager = new ScriptEngineManager(this.context.getClassLoader());
                    ScriptEngineFactory factory = manager.getEngineFactories().stream().filter(t -> !Collections.disjoint(t.getExtensions(), this.getExtensions())).findFirst().orElse(null);
                    Settings settings = new Settings();
                    this.context.classpath.stream().forEach(t -> settings.classpath().append(t));
                    Object out = type.getMethod("apply$default$3", new Class[0]).invoke(null, new Object[0]);
                    ScriptEngine scripted = type.cast(type.getMethod("apply", ScriptEngineFactory.class, Settings.class, PrintWriter.class).invoke(null, factory, settings, out));
                    Bindings bindings = this.context.context.getBindings(100);
                    scripted.setBindings(bindings, 100);
                    if (this.initialize(scripted)) {
                        this.engine = scripted;
                    }
                }
                catch (NoClassDefFoundError manager) {
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            } else {
                super.engine();
            }
        } else {
            super.engine();
        }
        return this.engine;
    }

    protected boolean initialize(ScriptEngine engine) {
        boolean initialized = true;
        if (this.isScriptedScriptEngine) {
            ClassPathResource resource = this.getInitScript(this.getExtensions());
            if (initialized && resource != null) {
                try {
                    this.eval(engine, resource);
                }
                catch (Throwable throwable) {
                    initialized = false;
                    throwable.printStackTrace(System.err);
                }
            }
        } else {
            initialized = super.initialize(engine);
        }
        if (initialized) {
            for (Method method : NotebookContext.getNotebookFunctions()) {
            }
        }
        return initialized;
    }

    protected void execute(String code) {
        ScriptEngine engine = this.engine();
        if (engine != null) {
            for (String string : this.context.classpath) {
            }
            for (String statement : this.context.imports) {
                try {
                    statement = statement.replaceAll("[;]", "").replaceAll("[\\p{Space}]+", " ").replaceAll("import static ", "import ").replaceAll("[*]", "_").strip();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }
            if (this.isScriptedScriptEngine && !code.isBlank()) {
                try {
                    this.render(this.eval(engine, code));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            } else {
                super.execute(code);
            }
        } else {
            super.execute(code);
        }
    }

    @Generated
    public Scala() {
    }

    @Generated
    public String toString() {
        return "Scala(isScriptedScriptEngine=" + this.isScriptedScriptEngine + ")";
    }
}

