/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.magic;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.databind.JsonNode;
import ganymede.notebook.AbstractMagic;
import ganymede.notebook.Description;
import ganymede.notebook.Magic;
import java.util.Collections;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.DSLContext;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.Result;
import org.jooq.exception.DataAccessException;
import picocli.CommandLine;

@ServiceProviderFor(value={Magic.class})
@Description(value="Execute code in SQL REPL")
public class SQL
extends AbstractMagic {
    @Generated
    private static final Logger log = LogManager.getLogger(SQL.class);
    private DSLContext dsl = null;

    public void execute(String line0, String code, JsonNode metadata) throws Exception {
        try {
            if (this.dsl != null && !this.context.sql.values().contains(this.dsl)) {
                this.dsl = null;
            }
            String[] argv = Magic.getCellMagicCommand((String)line0);
            Arguments arguments = new Arguments();
            this.parse(argv, arguments);
            if (arguments.getUrl() != null) {
                this.dsl = arguments.dsl();
            }
            if (!code.isBlank()) {
                if (this.dsl == null) {
                    this.dsl = arguments.dsl();
                }
                this.context.sql.queries.clear();
                this.context.sql.results.clear();
                Queries queries = this.dsl.parser().parse(code);
                Collections.addAll(this.context.sql.queries, queries.queries());
                for (Query query : queries) {
                    Result result = this.dsl.fetch(query.getSQL());
                    this.context.sql.results.add(result);
                    if (!arguments.isPrint()) continue;
                    this.context.print((Object)result);
                }
            } else if (!this.context.sql.isEmpty()) {
                this.context.sql.keySet().forEach(System.out::println);
            } else {
                System.out.println("No JDBC connections have been established.");
            }
        }
        catch (CommandLine.ParameterException exception) {
            System.err.println(exception.getMessage());
            System.err.println();
            exception.getCommandLine().usage(System.err);
        }
        catch (DataAccessException exception) {
            System.err.println(exception.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public String getUsage() {
        return this.getUsage(new Arguments());
    }

    @Generated
    public SQL() {
    }

    @Generated
    public String toString() {
        return "SQL(dsl=" + this.dsl + ")";
    }

    @CommandLine.Command
    private class Arguments {
        @CommandLine.Parameters(description={"JDBC Connection URL"}, index="0", arity="0..1")
        private String url = null;
        @CommandLine.Parameters(description={"JDBC Connection Username"}, index="1", arity="0..1", defaultValue="root")
        private String username = null;
        @CommandLine.Parameters(description={"JDBC Connection Password"}, index="2", arity="0..1")
        private String password = null;
        @CommandLine.Option(names={"--no-print"}, negatable=true, description={"Print query results.  true by default"})
        private boolean print = true;

        public DSLContext dsl() {
            return ((SQL)SQL.this).context.sql.connect(this.getUrl(), this.getUsername(), this.getPassword());
        }

        @Generated
        public Arguments() {
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public boolean isPrint() {
            return this.print;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public void setPrint(boolean print) {
            this.print = print;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments other = (Arguments)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPrint() != other.isPrint()) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Arguments;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPrint() ? 79 : 97);
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SQL.Arguments(url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", print=" + this.isPrint() + ")";
        }
    }
}

