/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.magic;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ganymede.kernel.client.KernelRestClient;
import ganymede.kernel.magic.Mustache;
import ganymede.notebook.AbstractRenderer;
import ganymede.notebook.Description;
import ganymede.notebook.ForClass;
import ganymede.notebook.Magic;
import ganymede.notebook.Renderer;
import ganymede.notebook.ScriptEngineName;
import ganymede.server.Message;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.front.matter.YamlFrontMatterExtension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.heading.anchor.HeadingAnchorExtension;
import org.commonmark.ext.image.attributes.ImageAttributesExtension;
import org.commonmark.ext.ins.InsExtension;
import org.commonmark.ext.task.list.items.TaskListItemsExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.text.TextContentRenderer;

@ServiceProviderFor(value={Magic.class})
@Description(value="Markdown template evaluator")
@ScriptEngineName(value="mustache")
public class Markdown
extends Mustache {
    @Generated
    private static final Logger log = LogManager.getLogger(Markdown.class);
    private static final List<Extension> EXTENSIONS = new ArrayList<Extension>();
    public static final List<Class<? extends Extension>> TYPES = List.of(AutolinkExtension.class, StrikethroughExtension.class, TablesExtension.class, HeadingAnchorExtension.class, ImageAttributesExtension.class, InsExtension.class, TaskListItemsExtension.class, YamlFrontMatterExtension.class);
    private final Parser parser = Parser.builder().extensions(EXTENSIONS).build();

    @Override
    protected void render(Object object) {
        try {
            String markdown = (String)object;
            Node node = this.parser.parse(markdown);
            new KernelRestClient().print((JsonNode)Message.mime_bundle(node, new Object[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    @Generated
    public Markdown() {
    }

    @Override
    @Generated
    public String toString() {
        return "Markdown(parser=" + this.parser + ")";
    }

    static {
        try {
            for (Class<? extends Extension> type : TYPES) {
                Extension extension = (Extension)type.getMethod("create", new Class[0]).invoke(null, new Object[0]);
                EXTENSIONS.add(extension);
            }
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    @ServiceProviderFor(value={Renderer.class})
    @ForClass(value=Node.class)
    public static class CommonMarkNodeRenderer
    extends AbstractRenderer {
        private HtmlRenderer html = HtmlRenderer.builder().extensions(EXTENSIONS).build();
        private TextContentRenderer text = TextContentRenderer.builder().extensions(EXTENSIONS).build();

        public void renderTo(ObjectNode bundle, Object object) {
            Node node = (Node)object;
            if (!bundle.with("data").has("text/html")) {
                bundle.with("data").put("text/html", this.html.render(node));
            }
            this.renderers.renderTo(bundle, (Object)this.text.render(node), new Object[0]);
        }

        @Generated
        public CommonMarkNodeRenderer() {
        }

        @Generated
        public String toString() {
            return "Markdown.CommonMarkNodeRenderer(html=" + this.html + ", text=" + this.text + ")";
        }
    }
}

