/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel.magic;

import ball.annotation.ServiceProviderFor;
import com.fasterxml.jackson.databind.JsonNode;
import ganymede.kernel.client.KernelRestClient;
import ganymede.kernel.renderer.ThymeleafRenderer;
import ganymede.notebook.AbstractMagic;
import ganymede.notebook.Description;
import ganymede.notebook.Magic;
import ganymede.server.Message;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ServiceProviderFor(value={Magic.class})
@Description(value="Lists available cell magics")
public class Magics
extends AbstractMagic {
    @Generated
    private static final Logger log = LogManager.getLogger(Magics.class);

    public void execute(String line0, String code, JsonNode metadata) throws Exception {
        String resource = ((Object)((Object)this)).getClass().getSimpleName();
        List rows = this.context.magics().values().stream().distinct().map(t -> new Row(String.join((CharSequence)", ", t.getMagicNames()), t.getDescription(), t.getUsage())).collect(Collectors.toList());
        Map<String, Object> map = Map.of("rows", rows);
        ThymeleafRenderer.Output html = ThymeleafRenderer.process(((Object)((Object)this)).getClass(), resource + ".html", "html", map);
        ThymeleafRenderer.Output text = ThymeleafRenderer.process(((Object)((Object)this)).getClass(), resource + ".text", "text", map);
        new KernelRestClient().print((JsonNode)Message.mime_bundle(html, text));
    }

    @Generated
    public Magics() {
    }

    @Generated
    public String toString() {
        return "Magics()";
    }

    private class Row {
        private final String names;
        private final String description;
        private final String usage;

        @ConstructorProperties(value={"names", "description", "usage"})
        @Generated
        public Row(String names, String description, String usage) {
            this.names = names;
            this.description = description;
            this.usage = usage;
        }

        @Generated
        public String getNames() {
            return this.names;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getUsage() {
            return this.usage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$names = this.getNames();
            String other$names = other.getNames();
            if (this$names == null ? other$names != null : !this$names.equals(other$names)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$usage = this.getUsage();
            String other$usage = other.getUsage();
            return !(this$usage == null ? other$usage != null : !this$usage.equals(other$usage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Row;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $names = this.getNames();
            result = result * 59 + ($names == null ? 43 : $names.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $usage = this.getUsage();
            result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Magics.Row(names=" + this.getNames() + ", description=" + this.getDescription() + ", usage=" + this.getUsage() + ")";
        }
    }
}

