/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel;

import com.fasterxml.jackson.databind.JsonNode;
import ganymede.kernel.ApiUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="kernel", description="the kernel API")
@RequestMapping(value={"${openapi.ganymedeKernelRestProtocol.base-path:}"})
public interface KernelApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="classpath", summary="Get Shell classpath", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/kernel/shell/classpath"}, produces={"application/json"})
    default public ResponseEntity<List<String>> classpath() {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "\"\"";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="display", summary="Jupyter display implemenation", responses={@ApiResponse(responseCode="200", description="OK")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/kernel/function/display"}, consumes={"application/json"})
    default public ResponseEntity<Void> display(@Parameter(name="body", description="Jupyter MIME bundle", required=true) @Valid @RequestBody JsonNode body) {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getExecuteRequest", summary="Get current execute_request", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=JsonNode.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/kernel/execute-request"}, produces={"application/json"})
    default public ResponseEntity<JsonNode> getExecuteRequest() {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="imports", summary="Get Java imports", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/kernel/shell/java/imports"}, produces={"application/json"})
    default public ResponseEntity<List<String>> imports() {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "\"\"";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="kernelId", summary="Get Kernel UUID", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/kernel/id"}, produces={"application/json"})
    default public ResponseEntity<UUID> kernelId() {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="print", summary="Jupyter print implemenation", responses={@ApiResponse(responseCode="200", description="OK")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/kernel/function/print"}, consumes={"application/json"})
    default public ResponseEntity<Void> print(@Parameter(name="body", description="Jupyter MIME bundle", required=true) @Valid @RequestBody JsonNode body) {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="variables", summary="Get Java variables", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/kernel/shell/java/variables"}, produces={"application/json"})
    default public ResponseEntity<Map<String, String>> variables() {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

