/*
 * Decompiled with CFR 0.152.
 */
package ganymede.kernel;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import ganymede.kernel.KernelApi;
import ganymede.notebook.Magic;
import ganymede.server.Message;
import ganymede.server.Server;
import ganymede.shell.Shell;
import ganymede.util.ObjectMappers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;
import picocli.CommandLine;

@SpringBootApplication
@RestController
@CommandLine.Command
public class Kernel
extends Server
implements KernelApi,
ApplicationContextAware,
ApplicationRunner {
    @Generated
    private static final Logger log = LogManager.getLogger(Kernel.class);
    private static final String JSE_HELP_LINK_TEXT_FORMAT = "Java SE %1$s & JDK %1$s";
    private static final String JSE_HELP_LINK_URL_FORMAT = "https://docs.oracle.com/en/java/javase/%1$s/docs/api/";
    @CommandLine.Option(description={"connection_file"}, names={"-f"}, arity="1")
    @Value(value="${connection-file:#{null}}")
    private String connection_file = null;
    @Value(value="${spark-home:#{null}}")
    private String spark_home = null;
    @Value(value="${hive-home:#{null}}")
    private String hive_home = null;
    @Value(value="${kernel.version}")
    private String kernel_version = null;
    @Value(value="classpath:kernel_info_reply.yml")
    private Resource kernel_info_reply = null;
    private final Shell shell = new Shell(this);
    private ApplicationContext context = null;
    private int port = -1;
    private ObjectNode kernel_info_reply_content = null;

    public int getPort() {
        return this.port;
    }

    @PostConstruct
    public void init() throws Exception {
        File parent;
        try (InputStream in = this.kernel_info_reply.getInputStream();){
            this.kernel_info_reply_content = (ObjectNode)ObjectMappers.YAML.readTree(in).with("content");
        }
        catch (Exception exception) {
            log.warn("{}", (Throwable)exception);
        }
        ObjectNode jse_help_link = new ObjectNode(JsonNodeFactory.instance);
        String version = System.getProperty("java.specification.version");
        jse_help_link.put("text", String.format(JSE_HELP_LINK_TEXT_FORMAT, version));
        jse_help_link.put("url", String.format(JSE_HELP_LINK_URL_FORMAT, version));
        this.kernel_info_reply_content.put("protocol_version", PROTOCOL_VERSION.toString());
        this.kernel_info_reply_content.withArray("help_links").add((JsonNode)jse_help_link);
        if (this.spark_home != null) {
            parent = Paths.get(this.spark_home, "jars").toFile();
            this.shell.addKnownDependenciesToClasspath(parent);
        }
        if (this.hive_home != null) {
            parent = Paths.get(this.hive_home, "lib").toFile();
            this.shell.addKnownDependenciesToClasspath(parent);
        }
        this.restart();
    }

    @PreDestroy
    public void destroy() {
        super.shutdown();
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @EventListener(value={ServletWebServerInitializedEvent.class})
    public void onApplicationEvent(ServletWebServerInitializedEvent event) {
        this.port = event.getWebServer().getPort();
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onApplicationEvent(ContextClosedEvent event) {
        super.shutdown();
    }

    @Override
    protected void bind(File file) throws IOException {
        super.bind(file);
        ObjectNode node = (ObjectNode)ObjectMappers.JSON.readTree(file);
        node.put("pid", ProcessHandle.current().pid());
        if (this.port > 0) {
            node.put("port", this.port);
        }
        ObjectMappers.JSON.writeValue(file, (Object)node);
    }

    @Override
    protected void restart() throws Exception {
        super.restart();
        this.shell.restart(this.getIn(), (PrintStream)this.getOut(), (PrintStream)this.getErr());
        this.setKernelSessionId(UUID.randomUUID());
    }

    @Override
    protected ObjectNode getKernelInfo() {
        return this.kernel_info_reply_content;
    }

    @Override
    protected void execute(String code) throws Exception {
        this.shell.execute(code);
    }

    @Override
    protected String evaluate(String expression) throws Exception {
        return this.shell.evaluate(expression);
    }

    @Override
    protected Magic.completeness isComplete(String code) throws Exception {
        return this.shell.isComplete(code);
    }

    @Override
    protected void interrupt() {
        Shell shell = this.shell;
        if (shell != null) {
            shell.stop();
        }
    }

    @Override
    public void shutdown() {
        SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }

    @Override
    public ResponseEntity<UUID> kernelId() {
        return new ResponseEntity((Object)this.getKernelId(), HttpStatus.OK);
    }

    @Override
    public ResponseEntity<JsonNode> getExecuteRequest() {
        return new ResponseEntity((Object)this.request.asObjectNode(), HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Void> display(JsonNode body) {
        boolean silent;
        Message request = this.request;
        if (request != null && !(silent = request.content().at("/silent").asBoolean())) {
            this.pub(request.display_data((ObjectNode)body.deepCopy()));
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Void> print(JsonNode body) {
        boolean silent;
        Message request = this.request;
        if (request != null && !(silent = request.content().at("/silent").asBoolean())) {
            this.pub(request.execute_result(this.execution_count.intValue(), (ObjectNode)body.deepCopy()));
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Override
    public ResponseEntity<List<String>> classpath() {
        List list = this.shell.classpath().stream().map(File::getAbsolutePath).collect(Collectors.toList());
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<List<String>> imports() {
        List list = this.shell.imports().stream().collect(Collectors.toList());
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Map<String, String>> variables() {
        return new ResponseEntity(this.shell.variables(), HttpStatus.OK);
    }

    public void run(ApplicationArguments arguments) throws Exception {
        new CommandLine((Object)this).setCaseInsensitiveEnumValuesAllowed(true).parseArgs(arguments.getNonOptionArgs().toArray(new String[0]));
        try {
            if (this.connection_file != null) {
                this.bind(this.connection_file);
            }
        }
        catch (Exception exception) {
            log.warn("{}", (Throwable)exception);
        }
    }

    @Generated
    public Kernel() {
    }

    @Override
    @Generated
    public String toString() {
        return "Kernel(connection_file=" + this.connection_file + ", spark_home=" + this.spark_home + ", hive_home=" + this.hive_home + ", kernel_version=" + this.kernel_version + ", kernel_info_reply=" + this.kernel_info_reply + ", shell=" + this.shell + ", context=" + this.context + ", port=" + this.getPort() + ", kernel_info_reply_content=" + this.kernel_info_reply_content + ")";
    }
}

