/*
 * Decompiled with CFR 0.152.
 */
package ganymede.jsr223;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.Version;
import ganymede.jsr223.AbstractScriptEngine;
import ganymede.jsr223.FreeMarkerScriptEngineFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

public class FreeMarkerScriptEngine
extends AbstractScriptEngine {
    @Generated
    private static final Logger log = LogManager.getLogger(FreeMarkerScriptEngine.class);
    private final FreeMarkerScriptEngineFactory factory;
    private final Configuration configuration;
    private final StringTemplateLoader loader = new StringTemplateLoader();

    protected FreeMarkerScriptEngine(FreeMarkerScriptEngineFactory factory) {
        this.factory = factory;
        Version version = new Version(factory.getEngineVersion());
        this.configuration = new Configuration(version);
        this.configuration.setTemplateLoader((TemplateLoader)this.loader);
    }

    @Override
    public String eval(String script, ScriptContext context) throws ScriptException {
        StringWriter out = new StringWriter();
        try {
            Arguments arguments = new Arguments();
            CommandLine.ParseResult result = this.parse(context, arguments);
            String name = String.class.getName() + "@" + Integer.toString(Objects.hashCode(script));
            this.loader.putTemplate(name, script);
            Template template = this.configuration.getTemplate(name);
            Bindings bindings = context.getBindings(100);
            template.process((Object)bindings, (Writer)out);
        }
        catch (CommandLine.ParameterException exception) {
            System.err.println(exception.getMessage());
            System.err.println();
            exception.getCommandLine().usage(System.err);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return out.toString();
    }

    @Override
    @Generated
    public FreeMarkerScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public StringTemplateLoader getLoader() {
        return this.loader;
    }

    @Override
    @Generated
    public String toString() {
        return "FreeMarkerScriptEngine(factory=" + this.getFactory() + ", configuration=" + this.getConfiguration() + ", loader=" + this.getLoader() + ")";
    }

    @CommandLine.Command
    private class Arguments {
        @Generated
        public Arguments() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments other = (Arguments)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Arguments;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "FreeMarkerScriptEngine.Arguments()";
        }
    }
}

