/*
 * Decompiled with CFR 0.152.
 */
package ganymede.dependency;

import ganymede.dependency.Analyzer;
import ganymede.dependency.POM;
import ganymede.shell.Shell;
import ganymede.util.PathPropertyMap;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transport.classpath.ClasspathTransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.springframework.boot.system.ApplicationHome;

public class Resolver
extends Analyzer {
    @Generated
    private static final Logger log = LogManager.getLogger(Resolver.class);
    private static final Set<String> LOGGING_IGNORE = Set.of("commons-logging:commons-logging:jar");
    private static final Set<String> JCL_BRIDGES = Set.of("org.slf4j:jcl-over-slf4j:jar", "org.springframework:spring-jcl:jar");
    private static final Set<String> SLF4J_BINDINGS = Set.of("ch.qos.logback:logback-classic:jar", "org.apache.logging.log4j:log4j-slf4j-impl:jar", "org.slf4j:slf4j-log4j12:jar", "org.slf4j:slf4j-reload4j:jar");
    private static final String DEPENDENCIES_FORMAT = "/META-INF/%s.dependencies";
    private final RepositorySystem system;
    private final POM pom;
    private final Set<File> classpath = new LinkedHashSet<File>();
    private final RepositoryImpl repository = new RepositoryImpl();
    private final PathPropertyMap pathMap = new PathPropertyMap();

    public POM pom() {
        return this.pom;
    }

    public Set<File> classpath() {
        return this.classpath;
    }

    public void addToRepository(File ... files) {
        Stream.of(files).map(File::getAbsoluteFile).map(this::getShadedArtifactSet).forEach(this.repository::resolve);
    }

    public List<File> addToClasspath(File ... files) {
        LinkedList<File> list = new LinkedList<File>();
        for (File file : files) {
            file = file.getAbsoluteFile();
            Set<Artifact> artifacts = this.getShadedArtifactSet(file).stream().map(this.repository::resolve).collect(Collectors.toSet());
            if (!artifacts.isEmpty()) {
                Artifact[] array = artifacts.toArray(new Artifact[0]);
                list.addAll(this.addToClasspath(array));
                continue;
            }
            if (!this.classpath.add(file)) continue;
            list.add(file);
        }
        return list;
    }

    public List<File> addToClasspath(Artifact ... artifacts) {
        LinkedList<File> list = new LinkedList<File>();
        List resolved = Stream.of(artifacts).map(this.repository::resolve).collect(Collectors.toList());
        for (Artifact artifact : resolved) {
            boolean ignore = false;
            String id = ArtifactIdUtils.toVersionlessId((Artifact)artifact);
            if (!ignore) {
                ignore |= LOGGING_IGNORE.contains(id);
            }
            if (!ignore && SLF4J_BINDINGS.contains(id)) {
                ignore |= this.repository.getArtifactsOn(this.classpath).map(ArtifactIdUtils::toVersionlessId).anyMatch(t -> SLF4J_BINDINGS.contains(t));
            }
            if (!ignore && JCL_BRIDGES.contains(id)) {
                ignore |= this.repository.getArtifactsOn(this.classpath).map(ArtifactIdUtils::toVersionlessId).anyMatch(t -> JCL_BRIDGES.contains(t));
            }
            if (ignore || this.classpath.contains(artifact.getFile())) continue;
            Artifact installed = this.repository.getArtifactsOn(this.classpath).filter(t -> ArtifactIdUtils.equalsVersionlessId((Artifact)artifact, (Artifact)t)).findFirst().orElse(null);
            if (installed == null) {
                if (!this.classpath.add(artifact.getFile())) continue;
                list.add(artifact.getFile());
                continue;
            }
            log.debug("Ignored resolved artifact {}", (Object)artifact);
            log.debug("    for {} @ {}", new Supplier[]{() -> installed.getVersion(), () -> this.pathMap.shorten(installed.getFile())});
        }
        return list;
    }

    public List<File> addKnownDependenciesToClasspath(File parent) {
        LinkedList<File> list = new LinkedList<File>();
        try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(parent.toPath(), "*.jar");){
            for (Path entry : stream2) {
                String resource = String.format(DEPENDENCIES_FORMAT, entry.getFileName());
                try {
                    InputStream in = this.getClass().getResourceAsStream(resource);
                    try {
                        if (in == null) continue;
                        Artifact[] artifacts = (Artifact[])this.parse(in).map(t -> t.setFile(new File(parent, t.getArtifactId() + "-" + t.getVersion() + "." + t.getExtension()).getAbsoluteFile())).filter(t -> t.getFile().exists()).toArray(Artifact[]::new);
                        list.addAll(this.addToClasspath(artifacts));
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (Exception exception) {
                    log.warn("Could not read {}", (Object)resource, (Object)exception);
                }
            }
        }
        catch (Exception exception) {
            log.warn("{}: {}", (Object)parent, (Object)exception);
        }
        return list;
    }

    public List<File> resolve(Shell shell, PrintStream out, PrintStream err, POM pom) {
        ArrayList<File> files = new ArrayList<File>();
        this.pom().merge(pom);
        RepositorySystemSession session = this.session(out, err);
        List repositories = this.pom().getRepositories().stream().collect(Collectors.toList());
        String scope = "runtime";
        DependencyFilter filter = DependencyFilterUtils.classpathFilter((String[])new String[]{scope});
        Iterator<Dependency> iterator = this.pom().getDependencies().iterator();
        while (iterator.hasNext()) {
            Dependency dependency = iterator.next();
            try {
                DependencyRequest request = new DependencyRequest(new CollectRequest(dependency, repositories), filter);
                for (ArtifactResult result : this.system.resolveDependencies(session, request).getArtifactResults()) {
                    Artifact artifact;
                    if (result.isResolved() && !this.classpath.contains((artifact = this.repository.resolve(result.getArtifact())).getFile())) {
                        Artifact installed = this.repository.getArtifactsOn(this.classpath).filter(t -> ArtifactIdUtils.equalsVersionlessId((Artifact)artifact, (Artifact)t)).findFirst().orElse(null);
                        if (installed == null) {
                            files.addAll(this.addToClasspath(artifact));
                        } else {
                            log.debug("Ignored resolved artifact {}", (Object)artifact);
                            log.debug("    for {} @ {}", new Supplier[]{() -> installed.getVersion(), () -> this.pathMap.shorten(installed.getFile())});
                        }
                    }
                    if (!result.isMissing()) continue;
                    result.getExceptions().stream().forEach(t -> err.println(t.getMessage()));
                }
                continue;
            }
            catch (DependencyResolutionException exception) {
                err.println(exception.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace(err);
            }
            iterator.remove();
        }
        return files;
    }

    private RepositorySystemSession session(PrintStream out, PrintStream err) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("aether.connector.userAgent", String.format("Ganymede/(Java %s; %s)", System.getProperty("java.version"), System.getProperty("os.version")));
        session.setConfigProperties(properties);
        session.setOffline(Objects.requireNonNullElse(this.pom().getOffline(), false).booleanValue());
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        Path path = Stream.of(this.pom().getLocalRepository(), System.getProperty("maven.repo.local")).filter(Objects::nonNull).map(x$0 -> Paths.get(x$0, new String[0])).findFirst().orElse(Paths.get(System.getProperty("user.home"), ".m2", "repository"));
        LocalRepository local = new LocalRepository(path.toFile());
        LocalRepositoryManager manager = this.system.newLocalRepositoryManager((RepositorySystemSession)session, local);
        session.setLocalRepositoryManager(manager);
        session.setWorkspaceReader((WorkspaceReader)this.repository);
        session.setRepositoryListener((org.eclipse.aether.RepositoryListener)new RepositoryListener(out, err));
        session.setTransferListener((org.eclipse.aether.transfer.TransferListener)new TransferListener(out, err));
        return session;
    }

    @Generated
    public Resolver() {
        try {
            DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterFactory.class, FileTransporterFactory.class);
            locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
            locator.addService(TransporterFactory.class, ClasspathTransporterFactory.class);
            this.system = (RepositorySystem)locator.getService(RepositorySystem.class);
            this.pom = POM.getDefault();
            this.classpath.add(new ApplicationHome(this.getClass()).getSource());
            this.classpath.stream().flatMap(t -> this.getShadedArtifactSet((File)t).stream()).forEach(this.repository::resolve);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    @Override
    @Generated
    public String toString() {
        return "Resolver(system=" + this.system + ", pom=" + this.pom + ", classpath=" + this.classpath + ", repository=" + this.repository + ", pathMap=" + this.pathMap + ")";
    }

    private class TransferListener
    extends AbstractTransferListener {
        private final PrintStream out;
        private final PrintStream err;

        public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
            this.err.format("%s%s: %s\n", event.getResource().getRepositoryUrl(), event.getResource().getResourceName(), event.getException().getMessage());
        }

        @ConstructorProperties(value={"out", "err"})
        @Generated
        public TransferListener(PrintStream out, PrintStream err) {
            this.out = out;
            this.err = err;
        }

        @Generated
        public String toString() {
            return "Resolver.TransferListener(out=" + this.out + ", err=" + this.err + ")";
        }
    }

    private class RepositoryListener
    extends AbstractRepositoryListener {
        private final PrintStream out;
        private final PrintStream err;

        @ConstructorProperties(value={"out", "err"})
        @Generated
        public RepositoryListener(PrintStream out, PrintStream err) {
            this.out = out;
            this.err = err;
        }

        @Generated
        public String toString() {
            return "Resolver.RepositoryListener(out=" + this.out + ", err=" + this.err + ")";
        }
    }

    private class RepositoryImpl
    extends TreeMap<String, Artifact>
    implements WorkspaceReader {
        private static final long serialVersionUID = -1L;

        public Set<Artifact> resolve(Set<Artifact> set) {
            LinkedHashSet resolved = set.stream().map(this::resolve).collect(Collectors.toCollection(LinkedHashSet::new));
            return resolved;
        }

        public Artifact resolve(Artifact artifact) {
            if (artifact.getFile() == null) {
                throw new IllegalArgumentException();
            }
            return this.computeIfAbsent(ArtifactIdUtils.toId((Artifact)artifact), k -> artifact);
        }

        public Stream<Artifact> getArtifactsOn(Set<File> classpath) {
            return this.values().stream().filter(t -> classpath.contains(t.getFile()));
        }

        public WorkspaceRepository getRepository() {
            return new WorkspaceRepository(this.getClass().getPackage().getName());
        }

        public File findArtifact(Artifact artifact) {
            String id = ArtifactIdUtils.toId((Artifact)artifact);
            File file = this.values().stream().filter(t -> Objects.equals(id, ArtifactIdUtils.toId((Artifact)t))).map(Artifact::getFile).findFirst().orElse(null);
            return file;
        }

        public List<String> findVersions(Artifact artifact) {
            List<String> list = this.values().stream().filter(t -> ArtifactIdUtils.equalsVersionlessId((Artifact)artifact, (Artifact)t)).map(Artifact::getVersion).collect(Collectors.toList());
            return list;
        }

        @Generated
        public RepositoryImpl() {
        }
    }
}

