/*
 * Decompiled with CFR 0.152.
 */
package ganymede.dependency;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import ganymede.util.ObjectMappers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@JsonPropertyOrder(value={"localRepository", "interactiveMode", "offline", "repositories", "dependencies"})
public class POM {
    @Generated
    private static final Logger log = LogManager.getLogger(POM.class);
    private static final SimpleModule MODULE = new SimpleModule().addDeserializer(Dependency.class, (JsonDeserializer)new DependencyDeserializer()).addSerializer(Dependency.class, (JsonSerializer)new DependencySerializer()).addDeserializer(RemoteRepository.class, (JsonDeserializer)new RemoteRepositoryDeserializer()).addSerializer(RemoteRepository.class, (JsonSerializer)new RemoteRepositorySerializer()).addDeserializer(RepositoryPolicy.class, (JsonDeserializer)new RepositoryPolicyDeserializer());
    private static final ObjectMapper YAML_OBJECT_MAPPER = ObjectMappers.YAML.registerModule((Module)MODULE).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    private String localRepository = null;
    private Boolean interactiveMode = null;
    private Boolean offline = null;
    private Set<RemoteRepository> repositories = new LinkedHashSet<RemoteRepository>();
    private Set<Dependency> dependencies = new LinkedHashSet<Dependency>();

    public static POM getDefault() throws IOException {
        POM pom = null;
        String resource = POM.class.getSimpleName() + ".yaml";
        try (InputStream in = POM.class.getResourceAsStream(resource);){
            pom = (POM)YAML_OBJECT_MAPPER.readValue(in, POM.class);
        }
        return pom;
    }

    public static POM parse(String yaml) throws Exception {
        return (POM)YAML_OBJECT_MAPPER.readValue(yaml, POM.class);
    }

    public void merge(POM that) {
        this.update(this, that, POM::getLocalRepository, this::setLocalRepository);
        this.update(this, that, POM::getInteractiveMode, this::setInteractiveMode);
        this.update(this, that, POM::getOffline, this::setOffline);
        Set ids = that.getRepositories().stream().map(t -> t.getId()).filter(Objects::nonNull).collect(Collectors.toSet());
        Set urls = that.getRepositories().stream().map(t -> t.getUrl()).filter(Objects::nonNull).collect(Collectors.toSet());
        this.getRepositories().removeIf(t -> ids.contains(t.getId()) || urls.contains(t.getUrl()));
        this.getRepositories().addAll(that.getRepositories());
        Set keys = that.getDependencies().stream().map(Dependency::getArtifact).map(t -> ArtifactIdUtils.toVersionlessId((Artifact)t)).collect(Collectors.toSet());
        this.getDependencies().removeIf(t -> keys.contains(ArtifactIdUtils.toVersionlessId((Artifact)t.getArtifact())));
        this.getDependencies().addAll(that.getDependencies());
    }

    private <T, U> boolean update(T left, T right, Function<T, U> get, Consumer<U> set) {
        boolean modified;
        U value = get.apply(right);
        boolean bl = modified = value != null && !Objects.equals(get.apply(left), value);
        if (modified) {
            set.accept(value);
        }
        return modified;
    }

    public void writeTo(OutputStream out) throws IOException {
        YAML_OBJECT_MAPPER.writeValue(out, (Object)this);
    }

    private static String asText(JsonNode node, String name) {
        return POM.asText(node, name, null);
    }

    private static String asText(JsonNode node, String name, String defaultValue) {
        return node.has(name) ? node.get(name).asText() : defaultValue;
    }

    @Generated
    public String getLocalRepository() {
        return this.localRepository;
    }

    @Generated
    public Boolean getInteractiveMode() {
        return this.interactiveMode;
    }

    @Generated
    public Boolean getOffline() {
        return this.offline;
    }

    @Generated
    public Set<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    @Generated
    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    @Generated
    public void setInteractiveMode(Boolean interactiveMode) {
        this.interactiveMode = interactiveMode;
    }

    @Generated
    public void setOffline(Boolean offline) {
        this.offline = offline;
    }

    @Generated
    public void setRepositories(Set<RemoteRepository> repositories) {
        this.repositories = repositories;
    }

    @Generated
    public void setDependencies(Set<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof POM)) {
            return false;
        }
        POM other = (POM)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$interactiveMode = this.getInteractiveMode();
        Boolean other$interactiveMode = other.getInteractiveMode();
        if (this$interactiveMode == null ? other$interactiveMode != null : !((Object)this$interactiveMode).equals(other$interactiveMode)) {
            return false;
        }
        Boolean this$offline = this.getOffline();
        Boolean other$offline = other.getOffline();
        if (this$offline == null ? other$offline != null : !((Object)this$offline).equals(other$offline)) {
            return false;
        }
        String this$localRepository = this.getLocalRepository();
        String other$localRepository = other.getLocalRepository();
        if (this$localRepository == null ? other$localRepository != null : !this$localRepository.equals(other$localRepository)) {
            return false;
        }
        Set<RemoteRepository> this$repositories = this.getRepositories();
        Set<RemoteRepository> other$repositories = other.getRepositories();
        if (this$repositories == null ? other$repositories != null : !((Object)this$repositories).equals(other$repositories)) {
            return false;
        }
        Set<Dependency> this$dependencies = this.getDependencies();
        Set<Dependency> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof POM;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $interactiveMode = this.getInteractiveMode();
        result = result * 59 + ($interactiveMode == null ? 43 : ((Object)$interactiveMode).hashCode());
        Boolean $offline = this.getOffline();
        result = result * 59 + ($offline == null ? 43 : ((Object)$offline).hashCode());
        String $localRepository = this.getLocalRepository();
        result = result * 59 + ($localRepository == null ? 43 : $localRepository.hashCode());
        Set<RemoteRepository> $repositories = this.getRepositories();
        result = result * 59 + ($repositories == null ? 43 : ((Object)$repositories).hashCode());
        Set<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    @Generated
    public POM() {
    }

    @Generated
    public String toString() {
        return "POM(localRepository=" + this.getLocalRepository() + ", interactiveMode=" + this.getInteractiveMode() + ", offline=" + this.getOffline() + ", repositories=" + this.getRepositories() + ", dependencies=" + this.getDependencies() + ")";
    }

    private static class RepositoryPolicyDeserializer
    extends StdDeserializer<RepositoryPolicy> {
        private static final long serialVersionUID = -1L;

        public RepositoryPolicyDeserializer() {
            super(RepositoryPolicy.class);
        }

        public RepositoryPolicy deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            return new RepositoryPolicy(node.has("enabled") ? node.get("enabled").asBoolean() : true, POM.asText(node, "updatePolicy", "daily"), POM.asText(node, "checksumPolicy", "warn"));
        }

        @Generated
        public String toString() {
            return "POM.RepositoryPolicyDeserializer()";
        }
    }

    private static class RemoteRepositorySerializer
    extends StdSerializer<RemoteRepository> {
        private static final long serialVersionUID = -1L;

        public RemoteRepositorySerializer() {
            super(RemoteRepository.class);
        }

        public void serialize(RemoteRepository value, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonProcessingException {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("id", value.getId());
            map.put("layout", value.getContentType());
            map.put("url", value.getUrl());
            map.put("releases", (String)value.getPolicy(false));
            map.put("snapshots", (String)value.getPolicy(true));
            generator.writeObject(map);
        }

        @Generated
        public String toString() {
            return "POM.RemoteRepositorySerializer()";
        }
    }

    private static class RemoteRepositoryDeserializer
    extends StdDeserializer<RemoteRepository> {
        private static final long serialVersionUID = -1L;

        public RemoteRepositoryDeserializer() {
            super(RemoteRepository.class);
        }

        public RemoteRepository deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            RepositoryPolicy policy;
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            RemoteRepository.Builder builder = new RemoteRepository.Builder(POM.asText(node, "id"), POM.asText(node, "layout", "default"), POM.asText(node, "url"));
            if (node.has("releases")) {
                policy = (RepositoryPolicy)parser.getCodec().treeToValue((TreeNode)node.get("releases"), RepositoryPolicy.class);
                builder.setReleasePolicy(policy);
            }
            if (node.has("snapshots")) {
                policy = (RepositoryPolicy)parser.getCodec().treeToValue((TreeNode)node.get("snapshots"), RepositoryPolicy.class);
                builder.setSnapshotPolicy(policy);
            }
            return builder.build();
        }

        @Generated
        public String toString() {
            return "POM.RemoteRepositoryDeserializer()";
        }
    }

    private static class DependencySerializer
    extends StdSerializer<Dependency> {
        private static final long serialVersionUID = -1L;

        public DependencySerializer() {
            super(Dependency.class);
        }

        public void serialize(Dependency value, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonProcessingException {
            Artifact artifact = value.getArtifact();
            String string = Stream.of(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion()).filter(Objects::nonNull).filter(t -> !t.isBlank()).collect(Collectors.joining(":"));
            generator.writeString(string);
        }

        @Generated
        public String toString() {
            return "POM.DependencySerializer()";
        }
    }

    private static class DependencyDeserializer
    extends StdDeserializer<Dependency> {
        private static final long serialVersionUID = -1L;

        public DependencyDeserializer() {
            super(Dependency.class);
        }

        public Dependency deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            DefaultArtifact artifact = null;
            if (node instanceof ObjectNode) {
                artifact = new DefaultArtifact(POM.asText(node, "groupId"), POM.asText(node, "artifactId"), POM.asText(node, "classifier"), POM.asText(node, "type", "jar"), POM.asText(node, "version"), Map.of(), (File)null);
            } else {
                String[] strings = node.asText().split(":");
                artifact = new DefaultArtifact(strings[0], strings[1], strings.length > 4 ? strings[3] : null, strings.length > 3 ? strings[2] : "jar", strings.length > 2 ? strings[strings.length - 1] : null, Map.of(), (File)null);
            }
            return new Dependency((Artifact)artifact, POM.asText(node, "scope", "runtime"));
        }

        @Generated
        public String toString() {
            return "POM.DependencyDeserializer()";
        }
    }
}

