/*
 * Decompiled with CFR 0.152.
 */
package ganymede.dependency;

import ball.annotation.CompileTimeCheck;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class Analyzer {
    @Generated
    private static final Logger log = LogManager.getLogger(Analyzer.class);
    private static final String SHADED_DEPENDENCIES = "META-INF/shaded.dependencies";
    @CompileTimeCheck
    private static final Pattern POM_PROPERTIES = Pattern.compile("(?i)^META-INF/maven/(?<g>[^/]+)/(?<a>[^/]+)/pom.properties$");
    private static final List<List<String>> CANDIDATES = List.of(List.of("Bundle-SymbolicName", "Bundle-Name", "Bundle-Version"), List.of("Implementation-Vendor-Id", "Implementation-Title", "Implementation-Version"), List.of("Implementation-Vendor", "Implementation-Title", "Implementation-Version"));

    public Set<Artifact> getShadedArtifactSet(File file) {
        LinkedHashSet<Artifact> set;
        block25: {
            set = new LinkedHashSet<Artifact>();
            if (!file.isDirectory()) {
                try (JarFile jar = new JarFile(file);){
                    DefaultArtifact artifact;
                    Manifest manifest = jar.getManifest();
                    JarEntry entry = jar.getJarEntry(SHADED_DEPENDENCIES);
                    if (entry != null) {
                        try (InputStream in = jar.getInputStream(entry);){
                            this.parse(in).map(t -> t.setFile(file)).forEach(set::add);
                            break block25;
                        }
                    }
                    Attributes attributes = manifest != null ? manifest.getMainAttributes() : null;
                    List list = jar.stream().map(ZipEntry::getName).map(POM_PROPERTIES::matcher).filter(Matcher::matches).collect(Collectors.toList());
                    for (Matcher matcher : list) {
                        try {
                            InputStream in = jar.getInputStream(jar.getJarEntry(matcher.group()));
                            try {
                                Properties properties = new Properties();
                                properties.load(in);
                                if (Objects.equals(matcher.group("g"), properties.get("groupId")) && Objects.equals(matcher.group("a"), properties.get("artifactId"))) {
                                    DefaultArtifact artifact2 = this.artifact(matcher.group("g"), matcher.group("a"), properties.getProperty("version"), file);
                                    set.add((Artifact)artifact2);
                                    continue;
                                }
                                log.warn("{} does not specify {}:{}", (Object)(jar.getName() + "!/" + matcher.group()), (Object)matcher.group("g"), (Object)matcher.group("a"));
                            }
                            finally {
                                if (in == null) continue;
                                in.close();
                            }
                        }
                        catch (IOException exception) {
                            log.warn("{}", (Object)(jar.getName() + "!/" + matcher.group()), (Object)exception);
                        }
                    }
                    if (set.isEmpty() && attributes != null && (artifact = this.getArtifactFrom(attributes, file)) != null) {
                        set.add((Artifact)artifact);
                    }
                }
                catch (Exception exception) {
                    log.warn("{}", (Object)file, (Object)exception);
                }
            }
        }
        return set;
    }

    protected Stream<DefaultArtifact> parse(InputStream in) {
        Stream<DefaultArtifact> stream2 = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().map(String::strip).map(t -> t.split(":")).filter(t -> ((String[])t).length > 3).map(t -> new DefaultArtifact(t[0], t[1], null, t[2], t[3]));
        return stream2;
    }

    private DefaultArtifact getArtifactFrom(Attributes attributes, File file) {
        List coordinates = CANDIDATES.stream().map(t -> t.stream().map(attributes::getValue).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList())).filter(t -> t.size() == 3).findFirst().orElse(null);
        return coordinates != null ? this.artifact(coordinates, file) : null;
    }

    private DefaultArtifact artifact(String g, String a, String v, File file) {
        return new DefaultArtifact(g, a, null, "jar", v, Map.of(), file);
    }

    private DefaultArtifact artifact(List<String> coordinates, File file) {
        return this.artifact(coordinates.get(0), coordinates.get(1), coordinates.get(2), file);
    }

    @Generated
    public Analyzer() {
    }

    @Generated
    public String toString() {
        return "Analyzer()";
    }
}

