/*
 * Decompiled with CFR 0.152.
 */
package dev.haven.jclient.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum AccountType {
    BROKERAGE("BROKERAGE"),
    CREDIT("CREDIT"),
    DEPOSITORY("DEPOSITORY"),
    LOAN("LOAN"),
    OTHER("OTHER");

    private String value;

    private AccountType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountType fromValue(String value) {
        for (AccountType b : AccountType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter
    extends TypeAdapter<AccountType> {
        public void write(JsonWriter jsonWriter, AccountType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public AccountType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AccountType.fromValue(value);
        }
    }
}

