/*
 * Decompiled with CFR 0.152.
 */
package dev.haven.jclient.auth;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ApiKeyAuth
implements Interceptor {
    private final String location;
    private final String paramName;
    private String apiKey;

    public ApiKeyAuth(String location, String paramName) {
        this.location = location;
        this.paramName = paramName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if ("query".equals(this.location)) {
            URI newUri;
            String newQuery = request.url().uri().getQuery();
            String paramValue = this.paramName + "=" + this.apiKey;
            newQuery = newQuery == null ? paramValue : newQuery + "&" + paramValue;
            try {
                newUri = new URI(request.url().uri().getScheme(), request.url().uri().getAuthority(), request.url().uri().getPath(), newQuery, request.url().uri().getFragment());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            request = request.newBuilder().url(newUri.toURL()).build();
        } else if ("header".equals(this.location)) {
            request = request.newBuilder().addHeader(this.paramName, this.apiKey).build();
        }
        return chain.proceed(request);
    }
}

