/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.providers.AbstractJsonNode;
import dev.harrel.jsonschema.providers.MapUtil;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public final class SnakeYamlNode
extends AbstractJsonNode<Node> {
    private static final SafeConstructor CONSTR = new SafeConstructor(new LoaderOptions());
    private static final SafeConstructor.ConstructYamlBool BOOLEAN_CREATOR = new SafeConstructor.ConstructYamlBool(CONSTR);
    private static final SafeConstructor.ConstructYamlInt INT_CREATOR = new SafeConstructor.ConstructYamlInt(CONSTR);
    private static final SafeConstructor.ConstructYamlFloat NUMBER_CREATOR = new SafeConstructor.ConstructYamlFloat(CONSTR);
    private BigDecimal asNumber;

    private SnakeYamlNode(Node node, String jsonPointer) {
        super(Objects.requireNonNull(node), jsonPointer);
    }

    private SnakeYamlNode(Node node) {
        this(node, "");
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)BOOLEAN_CREATOR.construct((Node)this.node);
    }

    @Override
    public String asString() {
        return ((ScalarNode)this.node).getValue();
    }

    @Override
    public BigInteger asInteger() {
        return this.asNumber.toBigInteger();
    }

    @Override
    public BigDecimal asNumber() {
        return this.asNumber;
    }

    @Override
    List<JsonNode> createArray() {
        List arrayNode = ((SequenceNode)this.node).getValue();
        ArrayList<JsonNode> elements = new ArrayList<JsonNode>(arrayNode.size());
        for (int i = 0; i < arrayNode.size(); ++i) {
            elements.add(new SnakeYamlNode((Node)arrayNode.get(i), this.jsonPointer + "/" + i));
        }
        return elements;
    }

    @Override
    Map<String, JsonNode> createObject() {
        List objectNode = ((MappingNode)this.node).getValue();
        HashMap<String, JsonNode> map = MapUtil.newHashMap(objectNode.size());
        for (NodeTuple entry : objectNode) {
            String key = ((ScalarNode)entry.getKeyNode()).getValue();
            map.put(key, new SnakeYamlNode(entry.getValueNode(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer(key)));
        }
        return map;
    }

    @Override
    SimpleType computeNodeType(Node node) {
        if (node instanceof SequenceNode) {
            return SimpleType.ARRAY;
        }
        if (node instanceof MappingNode) {
            return SimpleType.OBJECT;
        }
        if (node.getTag() == Tag.NULL) {
            return SimpleType.NULL;
        }
        if (node.getTag() == Tag.BOOL) {
            return SimpleType.BOOLEAN;
        }
        if (node.getTag() == Tag.INT) {
            this.asNumber = SnakeYamlNode.intToBigDecimal(node);
            return SimpleType.INTEGER;
        }
        if (node.getTag() == Tag.FLOAT) {
            String asString = ((ScalarNode)node).getValue().toLowerCase();
            if (asString.contains(".inf") || asString.contains(".nan")) {
                return SimpleType.STRING;
            }
            this.asNumber = SnakeYamlNode.floatToBigDecimal(node);
            if (SnakeYamlNode.canConvertToInteger(this.asNumber)) {
                return SimpleType.INTEGER;
            }
            return SimpleType.NUMBER;
        }
        return SimpleType.STRING;
    }

    private static BigDecimal intToBigDecimal(Node node) {
        Object intObject = INT_CREATOR.construct(node);
        if (intObject instanceof Integer || intObject instanceof Long) {
            return BigDecimal.valueOf(((Number)intObject).longValue());
        }
        return new BigDecimal((BigInteger)intObject);
    }

    private static BigDecimal floatToBigDecimal(Node node) {
        String asString = ((ScalarNode)node).getValue();
        if (asString.contains(":")) {
            return BigDecimal.valueOf((Double)NUMBER_CREATOR.construct(node));
        }
        return new BigDecimal(asString);
    }

    public static final class Factory
    implements JsonNodeFactory {
        private final Yaml yaml;

        public Factory() {
            this(new Yaml());
        }

        public Factory(Yaml yaml) {
            this.yaml = yaml;
        }

        @Override
        public JsonNode wrap(Object node) {
            if (node instanceof SnakeYamlNode) {
                return new SnakeYamlNode((Node)((SnakeYamlNode)node).node);
            }
            if (node instanceof Node) {
                Node providerNode = (Node)node;
                Factory.assertKeyUniqueness(providerNode);
                return new SnakeYamlNode(providerNode);
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of org.yaml.snakeyaml.nodes.Node");
        }

        @Override
        public JsonNode create(String rawJson) {
            Node node = this.yaml.compose((Reader)new StringReader(rawJson));
            Factory.assertKeyUniqueness(node);
            return new SnakeYamlNode(node);
        }

        private static void assertKeyUniqueness(Node node) {
            Factory.assertKeyUniqueness(node, Collections.newSetFromMap(new IdentityHashMap()));
        }

        private static void assertKeyUniqueness(Node node, Set<Node> visited) {
            if (!(node instanceof CollectionNode) || !visited.add(node)) {
                return;
            }
            if (node instanceof SequenceNode) {
                for (Node element : ((SequenceNode)node).getValue()) {
                    Factory.assertKeyUniqueness(element, visited);
                }
            } else if (node instanceof MappingNode) {
                List tuples = ((MappingNode)node).getValue();
                HashSet<String> keys = new HashSet<String>();
                for (NodeTuple tuple : tuples) {
                    ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                    if (!keys.add(keyNode.getValue())) {
                        throw new IllegalArgumentException("Mapping key '" + keyNode.getValue() + "' is duplicated" + keyNode.getStartMark());
                    }
                    Factory.assertKeyUniqueness(tuple.getValueNode(), visited);
                }
            }
            visited.remove(node);
        }
    }
}

