/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.providers.AbstractJsonNode;
import dev.harrel.jsonschema.providers.MapUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;

public final class KotlinxJsonNode
extends AbstractJsonNode<JsonElement> {
    private BigDecimal asNumber;

    private KotlinxJsonNode(JsonElement node, String jsonPointer) {
        super(Objects.requireNonNull(node), jsonPointer);
    }

    private KotlinxJsonNode(JsonElement node) {
        this(node, "");
    }

    @Override
    public boolean asBoolean() {
        return Boolean.parseBoolean(((JsonPrimitive)this.node).getContent());
    }

    @Override
    public String asString() {
        return ((JsonPrimitive)this.node).getContent();
    }

    @Override
    public BigInteger asInteger() {
        return this.asNumber.toBigInteger();
    }

    @Override
    public BigDecimal asNumber() {
        return this.asNumber;
    }

    @Override
    List<JsonNode> createArray() {
        JsonArray array = (JsonArray)this.node;
        ArrayList<JsonNode> result = new ArrayList<JsonNode>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            result.add(new KotlinxJsonNode(array.get(i), this.jsonPointer + "/" + i));
        }
        return result;
    }

    @Override
    Map<String, JsonNode> createObject() {
        JsonObject object = (JsonObject)this.node;
        HashMap<String, JsonNode> result = MapUtil.newHashMap(object.size());
        for (Map.Entry entry : object.getEntries()) {
            result.put((String)entry.getKey(), new KotlinxJsonNode((JsonElement)entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer((String)entry.getKey())));
        }
        return result;
    }

    @Override
    SimpleType computeNodeType(JsonElement node) {
        if (node instanceof JsonNull) {
            return SimpleType.NULL;
        }
        if (node instanceof JsonObject) {
            return SimpleType.OBJECT;
        }
        if (node instanceof JsonArray) {
            return SimpleType.ARRAY;
        }
        if (node instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)node;
            if (primitive.isString()) {
                return SimpleType.STRING;
            }
            String content = primitive.getContent();
            if ("true".equals(content) || "false".equals(content)) {
                return SimpleType.BOOLEAN;
            }
            this.asNumber = new BigDecimal(content);
            if (KotlinxJsonNode.canConvertToInteger(this.asNumber)) {
                return SimpleType.INTEGER;
            }
            return SimpleType.NUMBER;
        }
        throw new IllegalArgumentException(String.format("Unknown node class [%s]", node.getClass()));
    }

    public static final class Factory
    implements JsonNodeFactory {
        private final Json json;

        public Factory() {
            this((Json)Json.Default);
        }

        public Factory(Json json) {
            this.json = json;
        }

        @Override
        public KotlinxJsonNode wrap(Object node) {
            if (node instanceof KotlinxJsonNode) {
                return new KotlinxJsonNode((JsonElement)((KotlinxJsonNode)node).node);
            }
            if (node instanceof JsonElement) {
                return new KotlinxJsonNode((JsonElement)node);
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of kotlinx.serialization.json.JsonElement");
        }

        @Override
        public KotlinxJsonNode create(String rawJson) {
            return new KotlinxJsonNode(this.json.parseToJsonElement(rawJson));
        }
    }
}

