/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.Dialects;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.SpecificationVersion;
import dev.harrel.jsonschema.Validator;
import dev.harrel.jsonschema.providers.JacksonNode;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public final class ValidatorFactory {
    private Dialect dialect = new Dialects.Draft2020Dialect();
    private EvaluatorFactory evaluatorFactory;
    private Supplier<JsonNodeFactory> schemaNodeFactory = JacksonNode.Factory::new;
    private Supplier<JsonNodeFactory> instanceNodeFactory = this.schemaNodeFactory;
    private SchemaResolver schemaResolver = new DefaultSchemaResolver();
    private boolean disabledSchemaValidation = false;

    public Validator createValidator() {
        EvaluatorFactory compositeFactory = this.evaluatorFactory == null ? this.dialect.getEvaluatorFactory() : EvaluatorFactory.compose(this.evaluatorFactory, this.dialect.getEvaluatorFactory());
        JsonNodeFactory schemaFactory = this.schemaNodeFactory.get();
        JsonNodeFactory instanceFactory = this.instanceNodeFactory.get();
        return new Validator(this.dialect, compositeFactory, schemaFactory, instanceFactory, this.schemaResolver, this.disabledSchemaValidation);
    }

    public ValidatorFactory withDialect(Dialect dialect) {
        this.dialect = Objects.requireNonNull(dialect);
        return this;
    }

    public ValidatorFactory withEvaluatorFactory(EvaluatorFactory evaluatorFactory) {
        this.evaluatorFactory = Objects.requireNonNull(evaluatorFactory);
        return this;
    }

    public ValidatorFactory withJsonNodeFactory(JsonNodeFactory jsonNodeFactory) {
        return this.withJsonNodeFactories(jsonNodeFactory, jsonNodeFactory);
    }

    public ValidatorFactory withJsonNodeFactories(JsonNodeFactory schemaNodeFactory, JsonNodeFactory instanceNodeFactory) {
        Objects.requireNonNull(schemaNodeFactory);
        Objects.requireNonNull(instanceNodeFactory);
        this.schemaNodeFactory = () -> schemaNodeFactory;
        this.instanceNodeFactory = () -> instanceNodeFactory;
        return this;
    }

    public ValidatorFactory withSchemaResolver(SchemaResolver schemaResolver) {
        this.schemaResolver = SchemaResolver.compose(Objects.requireNonNull(schemaResolver), new DefaultSchemaResolver());
        return this;
    }

    public ValidatorFactory withDisabledSchemaValidation(boolean disabledSchemaValidation) {
        this.disabledSchemaValidation = disabledSchemaValidation;
        return this;
    }

    public Validator.Result validate(String rawSchema, String rawInstance) {
        return this.validate(this.schemaNodeFactory.get().create(rawSchema), this.instanceNodeFactory.get().create(rawInstance));
    }

    public Validator.Result validate(Object schemaProviderNode, String rawInstance) {
        return this.validate(this.schemaNodeFactory.get().wrap(schemaProviderNode), this.instanceNodeFactory.get().create(rawInstance));
    }

    public Validator.Result validate(JsonNode schemaNode, String rawInstance) {
        return this.validate(schemaNode, this.instanceNodeFactory.get().create(rawInstance));
    }

    public Validator.Result validate(String rawSchema, Object instanceProviderNode) {
        return this.validate(this.schemaNodeFactory.get().create(rawSchema), this.instanceNodeFactory.get().wrap(instanceProviderNode));
    }

    public Validator.Result validate(Object schemaProviderNode, Object instanceProviderNode) {
        return this.validate(this.schemaNodeFactory.get().wrap(schemaProviderNode), this.instanceNodeFactory.get().wrap(instanceProviderNode));
    }

    public Validator.Result validate(JsonNode schemaNode, Object instanceProviderNode) {
        return this.validate(schemaNode, this.instanceNodeFactory.get().wrap(instanceProviderNode));
    }

    public Validator.Result validate(String rawSchema, JsonNode instanceNode) {
        return this.validate(this.schemaNodeFactory.get().create(rawSchema), instanceNode);
    }

    public Validator.Result validate(Object schemaProviderNode, JsonNode instanceNode) {
        return this.validate(this.schemaNodeFactory.get().wrap(schemaProviderNode), instanceNode);
    }

    public Validator.Result validate(JsonNode schemaNode, JsonNode instanceNode) {
        Validator validator = this.createValidator();
        URI uri = validator.registerSchema(schemaNode);
        return validator.validate(uri, instanceNode);
    }

    static class DefaultSchemaResolver
    implements SchemaResolver {
        private final ConcurrentMap<String, String> schemaCache = new ConcurrentHashMap<String, String>();

        DefaultSchemaResolver() {
        }

        @Override
        public SchemaResolver.Result resolve(String uri) {
            if (this.schemaCache.containsKey(uri)) {
                return SchemaResolver.Result.fromString((String)this.schemaCache.get(uri));
            }
            Optional<String> rawSchema = Arrays.stream(SpecificationVersion.values()).map(spec -> spec.resolveResource(uri)).filter(Optional::isPresent).map(Optional::get).findFirst();
            rawSchema.ifPresent(s -> this.schemaCache.put(uri, (String)s));
            return rawSchema.map(SchemaResolver.Result::fromString).orElse(SchemaResolver.Result.empty());
        }
    }
}

