/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeUtil;
import dev.harrel.jsonschema.MetaSchemaValidator;
import dev.harrel.jsonschema.OptionalUtil;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class JsonParser {
    private final Dialect dialect;
    private final EvaluatorFactory evaluatorFactory;
    private final SchemaRegistry schemaRegistry;
    private final MetaSchemaValidator metaSchemaValidator;
    private final Map<URI, MetaSchemaData> unfinishedSchemas = new HashMap<URI, MetaSchemaData>();

    JsonParser(Dialect dialect, EvaluatorFactory evaluatorFactory, SchemaRegistry schemaRegistry, MetaSchemaValidator metaSchemaValidator) {
        this.dialect = Objects.requireNonNull(dialect);
        this.evaluatorFactory = Objects.requireNonNull(evaluatorFactory);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.metaSchemaValidator = Objects.requireNonNull(metaSchemaValidator);
    }

    synchronized URI parseRootSchema(URI baseUri, JsonNode node) {
        SchemaRegistry.State snapshot = this.schemaRegistry.createSnapshot();
        try {
            return this.parseRootSchemaInternal(UriUtil.getUriWithoutFragment(baseUri), node);
        }
        catch (RuntimeException e) {
            this.schemaRegistry.restoreSnapshot(snapshot);
            throw e;
        }
    }

    private URI parseRootSchemaInternal(URI baseUri, JsonNode node) {
        Optional<Map<String, JsonNode>> objectMapOptional = JsonNodeUtil.getAsObject(node);
        URI metaSchemaUri = OptionalUtil.firstPresent(() -> objectMapOptional.flatMap(obj -> JsonNodeUtil.getStringField(obj, "$schema")), () -> Optional.ofNullable(this.dialect.getMetaSchema())).map(URI::create).orElse(null);
        Optional<URI> providedSchemaId = objectMapOptional.flatMap(obj -> JsonNodeUtil.getStringField(obj, "$id")).filter(JsonNodeUtil::validateIdField).map(UriUtil::getUriWithoutFragment).filter(id -> !baseUri.equals(id));
        Map<String, Boolean> vocabulariesObject = objectMapOptional.flatMap(JsonNodeUtil::getVocabulariesObject).orElse(this.dialect.getDefaultVocabularyObject());
        MetaSchemaData metaSchemaData = new MetaSchemaData(vocabulariesObject);
        this.unfinishedSchemas.put(baseUri, metaSchemaData);
        providedSchemaId.ifPresent(id -> this.unfinishedSchemas.put((URI)id, metaSchemaData));
        URI finalUri = providedSchemaId.orElse(baseUri);
        Set<String> activeVocabularies = this.validateAgainstMetaSchema(node, metaSchemaUri, finalUri.toString());
        if (node.isBoolean()) {
            SchemaParsingContext ctx = new SchemaParsingContext(this.dialect, this.schemaRegistry, baseUri, Collections.emptyMap());
            List<EvaluatorWrapper> evaluators = Collections.singletonList(new EvaluatorWrapper(null, node, Schema.getBooleanEvaluator(node.asBoolean())));
            this.schemaRegistry.registerSchema(ctx, node, evaluators, activeVocabularies);
        } else if (objectMapOptional.isPresent()) {
            Map<String, JsonNode> objectMap = objectMapOptional.get();
            SchemaParsingContext ctx = new SchemaParsingContext(this.dialect, this.schemaRegistry, finalUri, objectMap);
            List<EvaluatorWrapper> evaluators = this.parseEvaluators(ctx, objectMap, node.getJsonPointer());
            this.schemaRegistry.registerSchema(ctx, node, evaluators, activeVocabularies);
            providedSchemaId.ifPresent(id -> this.schemaRegistry.registerAlias((URI)id, baseUri));
        }
        metaSchemaData.parsed();
        this.unfinishedSchemas.remove(baseUri);
        providedSchemaId.ifPresent(this.unfinishedSchemas::remove);
        return finalUri;
    }

    private void parseNode(SchemaParsingContext ctx, JsonNode node) {
        if (node.isBoolean()) {
            this.parseBoolean(ctx, node);
        } else if (node.isArray()) {
            this.parseArray(ctx, node);
        } else if (node.isObject()) {
            this.parseObject(ctx, node);
        }
    }

    private void parseBoolean(SchemaParsingContext ctx, JsonNode node) {
        Evaluator booleanEvaluator = Schema.getBooleanEvaluator(node.asBoolean());
        List<EvaluatorWrapper> evaluators = Collections.singletonList(new EvaluatorWrapper(null, node, booleanEvaluator));
        this.schemaRegistry.registerSchema(ctx, node, evaluators, this.dialect.getSupportedVocabularies());
    }

    private void parseArray(SchemaParsingContext ctx, JsonNode node) {
        for (JsonNode element : node.asArray()) {
            this.parseNode(ctx, element);
        }
    }

    private void parseObject(SchemaParsingContext ctx, JsonNode node) {
        Map<String, JsonNode> objectMap = node.asObject();
        URI metaSchemaUri = JsonNodeUtil.getStringField(objectMap, "$schema").map(URI::create).orElse(null);
        Optional<URI> providedSchemaId = JsonNodeUtil.getStringField(objectMap, "$id").filter(JsonNodeUtil::validateIdField).map(URI::create);
        Map<String, Boolean> vocabularyObject = JsonNodeUtil.getVocabulariesObject(objectMap).orElse(this.dialect.getDefaultVocabularyObject());
        MetaSchemaData metaSchemaData = new MetaSchemaData(vocabularyObject);
        providedSchemaId.ifPresent(id -> this.unfinishedSchemas.put((URI)id, metaSchemaData));
        String absoluteUri = ctx.getAbsoluteUri(node);
        String finalUri = providedSchemaId.map(URI::toString).orElse(absoluteUri);
        Set<String> activeVocabularies = this.validateAgainstMetaSchema(node, metaSchemaUri, finalUri);
        if (providedSchemaId.isPresent()) {
            URI idUri = providedSchemaId.get();
            URI uri = ctx.getParentUri().resolve(idUri);
            SchemaParsingContext newCtx = ctx.withParentUri(uri);
            List<EvaluatorWrapper> evaluators = this.parseEvaluators(newCtx, objectMap, node.getJsonPointer());
            this.schemaRegistry.registerEmbeddedSchema(newCtx, uri, node, evaluators, activeVocabularies);
            metaSchemaData.parsed();
            this.unfinishedSchemas.remove(idUri);
        } else {
            this.schemaRegistry.registerSchema(ctx, node, this.parseEvaluators(ctx, objectMap, node.getJsonPointer()), activeVocabularies);
        }
    }

    private List<EvaluatorWrapper> parseEvaluators(SchemaParsingContext ctx, Map<String, JsonNode> object, String objectPath) {
        SchemaParsingContext newCtx = ctx.withCurrentSchemaContext(object);
        ArrayList<EvaluatorWrapper> evaluators = new ArrayList<EvaluatorWrapper>();
        for (Map.Entry<String, JsonNode> entry : object.entrySet()) {
            this.evaluatorFactory.create(newCtx, entry.getKey(), entry.getValue()).map(evaluator -> new EvaluatorWrapper((String)entry.getKey(), (JsonNode)entry.getValue(), (Evaluator)evaluator)).ifPresent(evaluators::add);
            this.parseNode(newCtx, entry.getValue());
        }
        if (evaluators.isEmpty()) {
            evaluators.add(new EvaluatorWrapper(null, objectPath, Schema.getBooleanEvaluator(true)));
        }
        return evaluators;
    }

    private Set<String> validateAgainstMetaSchema(JsonNode node, URI metaSchemaUri, String uri) {
        if (metaSchemaUri == null) {
            return this.dialect.getSupportedVocabularies();
        }
        if (!this.unfinishedSchemas.containsKey(metaSchemaUri)) {
            return this.metaSchemaValidator.validateSchema(this, metaSchemaUri, uri, node);
        }
        MetaSchemaData metaSchemaData = this.unfinishedSchemas.get(metaSchemaUri);
        metaSchemaData.callbacks.add(() -> this.metaSchemaValidator.validateSchema(this, metaSchemaUri, uri, node));
        return this.metaSchemaValidator.determineActiveVocabularies(metaSchemaData.vocabularyObject);
    }

    private static final class MetaSchemaData {
        private final Map<String, Boolean> vocabularyObject;
        private final List<Runnable> callbacks;

        private MetaSchemaData(Map<String, Boolean> vocabularyObject) {
            this.vocabularyObject = vocabularyObject;
            this.callbacks = new ArrayList<Runnable>();
        }

        void parsed() {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).run();
            }
        }
    }
}

