/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class DependentSchemasEvaluator
implements Evaluator {
    private final Map<String, CompoundUri> dependentSchemas;

    DependentSchemasEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        this.dependentSchemas = node.asObject().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ctx.getCompoundUri((JsonNode)e.getValue())));
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        ArrayList<String> failedFields = new ArrayList<String>();
        for (Map.Entry<String, JsonNode> e : node.asObject().entrySet()) {
            CompoundUri ref = this.dependentSchemas.get(e.getKey());
            if (ref == null || ctx.resolveInternalRefAndValidate(ref, node)) continue;
            failedFields.add(e.getKey());
        }
        if (failedFields.isEmpty()) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(String.format("Object does not match dependent schemas for some properties %s", failedFields));
    }
}

