/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import java.net.URI;
import java.util.Objects;

final class CompoundUri {
    final URI uri;
    final String fragment;

    static CompoundUri fromString(String ref) {
        String[] split = ref.split("#", -1);
        String fragment = split.length > 1 ? split[1] : "";
        return new CompoundUri(URI.create(split[0]), fragment);
    }

    CompoundUri(URI uri, String fragment) {
        this.uri = Objects.requireNonNull(uri);
        this.fragment = Objects.requireNonNull(fragment);
    }

    public String toString() {
        return this.fragment.isEmpty() ? this.uri.toString() : this.uri + "#" + this.fragment;
    }
}

