/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.AdditionalPropertiesEvaluator;
import dev.harrel.jsonschema.AllOfEvaluator;
import dev.harrel.jsonschema.AnyOfEvaluator;
import dev.harrel.jsonschema.ConstEvaluator;
import dev.harrel.jsonschema.ContainsEvaluator;
import dev.harrel.jsonschema.DependentRequiredEvaluator;
import dev.harrel.jsonschema.DependentSchemasEvaluator;
import dev.harrel.jsonschema.EnumEvaluator;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.ExclusiveMaximumEvaluator;
import dev.harrel.jsonschema.ExclusiveMinimumEvaluator;
import dev.harrel.jsonschema.IfThenElseEvaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.MaxContainsEvaluator;
import dev.harrel.jsonschema.MaxItemsEvaluator;
import dev.harrel.jsonschema.MaxLengthEvaluator;
import dev.harrel.jsonschema.MaxPropertiesEvaluator;
import dev.harrel.jsonschema.MaximumEvaluator;
import dev.harrel.jsonschema.MinContainsEvaluator;
import dev.harrel.jsonschema.MinItemsEvaluator;
import dev.harrel.jsonschema.MinLengthEvaluator;
import dev.harrel.jsonschema.MinPropertiesEvaluator;
import dev.harrel.jsonschema.MinimumEvaluator;
import dev.harrel.jsonschema.MultipleOfEvaluator;
import dev.harrel.jsonschema.NotEvaluator;
import dev.harrel.jsonschema.OneOfEvaluator;
import dev.harrel.jsonschema.PatternEvaluator;
import dev.harrel.jsonschema.PatternPropertiesEvaluator;
import dev.harrel.jsonschema.PropertiesEvaluator;
import dev.harrel.jsonschema.PropertyNamesEvaluator;
import dev.harrel.jsonschema.RefEvaluator;
import dev.harrel.jsonschema.RequiredEvaluator;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.TypeEvaluator;
import dev.harrel.jsonschema.UnevaluatedItemsEvaluator;
import dev.harrel.jsonschema.UnevaluatedPropertiesEvaluator;
import dev.harrel.jsonschema.UniqueItemsEvaluator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;

abstract class AbstractEvaluatorFactory
implements EvaluatorFactory {
    private final Set<String> ignoredKeywords;
    private final Map<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>> evaluatorsMap;

    AbstractEvaluatorFactory(List<String> ignoredKeywords) {
        this.ignoredKeywords = Collections.unmodifiableSet(new HashSet<String>(ignoredKeywords));
        Map<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>> evaluators = AbstractEvaluatorFactory.getDefaultEvaluatorsMap();
        this.configureEvaluatorsMap(evaluators);
        this.evaluatorsMap = Collections.unmodifiableMap(evaluators);
    }

    abstract void configureEvaluatorsMap(Map<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>> var1);

    @Override
    public Optional<Evaluator> create(SchemaParsingContext ctx, String fieldName, JsonNode node) {
        if (this.ignoredKeywords.contains(fieldName)) {
            return Optional.empty();
        }
        if (this.evaluatorsMap.containsKey(fieldName)) {
            try {
                return Optional.of(this.evaluatorsMap.get(fieldName).apply(ctx, node));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        if (node.isString()) {
            return Optional.of(new AnnotationEvaluator(node.asString()));
        }
        return Optional.empty();
    }

    private static Map<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>> getDefaultEvaluatorsMap() {
        HashMap<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>> map = new HashMap<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>>();
        map.put("type", (ctx, node) -> new TypeEvaluator((JsonNode)node));
        map.put("const", (ctx, node) -> new ConstEvaluator((JsonNode)node));
        map.put("enum", (ctx, node) -> new EnumEvaluator((JsonNode)node));
        map.put("multipleOf", (ctx, node) -> new MultipleOfEvaluator((JsonNode)node));
        map.put("maximum", (ctx, node) -> new MaximumEvaluator((JsonNode)node));
        map.put("exclusiveMaximum", (ctx, node) -> new ExclusiveMaximumEvaluator((JsonNode)node));
        map.put("minimum", (ctx, node) -> new MinimumEvaluator((JsonNode)node));
        map.put("exclusiveMinimum", (ctx, node) -> new ExclusiveMinimumEvaluator((JsonNode)node));
        map.put("maxLength", (ctx, node) -> new MaxLengthEvaluator((JsonNode)node));
        map.put("minLength", (ctx, node) -> new MinLengthEvaluator((JsonNode)node));
        map.put("pattern", (ctx, node) -> new PatternEvaluator((JsonNode)node));
        map.put("maxItems", (ctx, node) -> new MaxItemsEvaluator((JsonNode)node));
        map.put("minItems", (ctx, node) -> new MinItemsEvaluator((JsonNode)node));
        map.put("uniqueItems", (ctx, node) -> new UniqueItemsEvaluator((JsonNode)node));
        map.put("maxContains", (ctx, node) -> new MaxContainsEvaluator((JsonNode)node));
        map.put("minContains", (ctx, node) -> new MinContainsEvaluator((JsonNode)node));
        map.put("maxProperties", (ctx, node) -> new MaxPropertiesEvaluator((JsonNode)node));
        map.put("minProperties", (ctx, node) -> new MinPropertiesEvaluator((JsonNode)node));
        map.put("required", (ctx, node) -> new RequiredEvaluator((JsonNode)node));
        map.put("dependentRequired", (ctx, node) -> new DependentRequiredEvaluator((JsonNode)node));
        map.put("contains", ContainsEvaluator::new);
        map.put("additionalProperties", AdditionalPropertiesEvaluator::new);
        map.put("properties", PropertiesEvaluator::new);
        map.put("patternProperties", PatternPropertiesEvaluator::new);
        map.put("dependentSchemas", DependentSchemasEvaluator::new);
        map.put("propertyNames", PropertyNamesEvaluator::new);
        map.put("if", IfThenElseEvaluator::new);
        map.put("allOf", AllOfEvaluator::new);
        map.put("anyOf", AnyOfEvaluator::new);
        map.put("oneOf", OneOfEvaluator::new);
        map.put("not", NotEvaluator::new);
        map.put("unevaluatedItems", UnevaluatedItemsEvaluator::new);
        map.put("unevaluatedProperties", UnevaluatedPropertiesEvaluator::new);
        map.put("$ref", (ctx, node) -> new RefEvaluator((JsonNode)node));
        return map;
    }

    static class AnnotationEvaluator
    implements Evaluator {
        private final String annotation;

        public AnnotationEvaluator(String annotation) {
            this.annotation = annotation;
        }

        @Override
        public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
            return Evaluator.Result.success(this.annotation);
        }
    }
}

