/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SimpleType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

abstract class SimpleJsonNode
implements JsonNode {
    private final SimpleType nodeType;
    final Object node;
    final String jsonPointer;

    SimpleJsonNode(Object node, String jsonPointer) {
        this.nodeType = this.computeNodeType(node);
        this.node = node;
        this.jsonPointer = Objects.requireNonNull(jsonPointer);
    }

    @Override
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Override
    public SimpleType getNodeType() {
        return this.nodeType;
    }

    @Override
    public BigInteger asInteger() {
        if (this.node instanceof BigInteger) {
            return (BigInteger)this.node;
        }
        if (this.node instanceof BigDecimal) {
            return ((BigDecimal)this.node).toBigInteger();
        }
        return BigInteger.valueOf(((Number)this.node).longValue());
    }

    @Override
    public BigDecimal asNumber() {
        if (this.node instanceof BigDecimal) {
            return (BigDecimal)this.node;
        }
        if (this.node instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.node);
        }
        if (this.node instanceof Double) {
            return BigDecimal.valueOf((Double)this.node);
        }
        return BigDecimal.valueOf(((Number)this.node).longValue());
    }

    boolean isBoolean(Object node) {
        return node instanceof Boolean;
    }

    boolean isString(Object node) {
        return node instanceof Character || node instanceof String || node instanceof Enum;
    }

    boolean isInteger(Object node) {
        return node instanceof Integer || node instanceof Long || node instanceof BigInteger;
    }

    boolean isDecimal(Object node) {
        return node instanceof Double || node instanceof BigDecimal;
    }

    abstract boolean isNull(Object var1);

    abstract boolean isArray(Object var1);

    abstract boolean isObject(Object var1);

    SimpleType computeNodeType(Object node) {
        if (this.isNull(node)) {
            return SimpleType.NULL;
        }
        if (this.isBoolean(node)) {
            return SimpleType.BOOLEAN;
        }
        if (this.isString(node)) {
            return SimpleType.STRING;
        }
        if (this.isDecimal(node)) {
            if (node instanceof BigDecimal && ((BigDecimal)node).stripTrailingZeros().scale() <= 0) {
                return SimpleType.INTEGER;
            }
            if (node instanceof Double && ((Number)node).doubleValue() == Math.rint(((Number)node).doubleValue())) {
                return SimpleType.INTEGER;
            }
            return SimpleType.NUMBER;
        }
        if (this.isInteger(node)) {
            return SimpleType.INTEGER;
        }
        if (this.isArray(node)) {
            return SimpleType.ARRAY;
        }
        if (this.isObject(node)) {
            return SimpleType.OBJECT;
        }
        throw new IllegalArgumentException("Cannot assign type to node of class=" + node.getClass().getName());
    }
}

