/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.providers.MapUtil;
import dev.harrel.jsonschema.providers.SimpleJsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

public final class JettisonNode
extends SimpleJsonNode {
    private JettisonNode(Object node, String jsonPointer) {
        super(Objects.requireNonNull(node), jsonPointer);
    }

    public JettisonNode(Object node) {
        this(node, "");
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.node;
    }

    @Override
    public String asString() {
        return Objects.toString(this.isNull() ? null : this.node);
    }

    @Override
    public List<JsonNode> asArray() {
        ArrayList<JsonNode> elements = new ArrayList<JsonNode>();
        JSONArray arrayNode = (JSONArray)this.node;
        for (int i = 0; i < arrayNode.length(); ++i) {
            elements.add(new JettisonNode(arrayNode.opt(i), this.jsonPointer + "/" + elements.size()));
        }
        return elements;
    }

    @Override
    public Map<String, JsonNode> asObject() {
        JSONObject jsonObject = (JSONObject)this.node;
        HashMap<String, JsonNode> map = MapUtil.newHashMap(jsonObject.length());
        Iterator iterator = jsonObject.toMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            map.put(entry.getKey().toString(), new JettisonNode(entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer(entry.getKey().toString())));
        }
        return map;
    }

    @Override
    boolean isNull(Object node) {
        return JSONObject.NULL.equals(node) || JSONObject.EXPLICIT_NULL.equals(node);
    }

    @Override
    boolean isArray(Object node) {
        return node instanceof JSONArray;
    }

    @Override
    boolean isObject(Object node) {
        return node instanceof JSONObject;
    }

    static final class BigDecimalTokener
    extends JSONTokener {
        BigDecimalTokener(String s) {
            super(s);
            this.useBigDecimal = true;
        }
    }

    public static final class Factory
    implements JsonNodeFactory {
        @Override
        public JsonNode wrap(Object node) {
            if (node instanceof JettisonNode) {
                return (JettisonNode)node;
            }
            return new JettisonNode(node);
        }

        @Override
        public JsonNode create(String rawJson) {
            try {
                return new JettisonNode(new BigDecimalTokener(rawJson).nextValue());
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

