/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompositeEvaluatorFactory;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.MapEvaluatorFactory;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface EvaluatorFactory {
    public Optional<Evaluator> create(SchemaParsingContext var1, String var2, JsonNode var3);

    public static EvaluatorFactory compose(EvaluatorFactory ... factories) {
        return new CompositeEvaluatorFactory(factories);
    }

    public static final class Builder {
        private final Map<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>> providers = new HashMap<String, BiFunction<SchemaParsingContext, JsonNode, Evaluator>>();

        public Builder withKeyword(String keyword, BiFunction<SchemaParsingContext, JsonNode, Evaluator> evaluatorProvider) {
            this.providers.put(Objects.requireNonNull(keyword), Objects.requireNonNull(evaluatorProvider));
            return this;
        }

        public Builder withKeyword(String keyword, Function<JsonNode, Evaluator> evaluatorProvider) {
            return this.withKeyword(keyword, (SchemaParsingContext ctx, JsonNode jsonNode) -> (Evaluator)evaluatorProvider.apply((JsonNode)jsonNode));
        }

        public Builder withKeyword(String keyword, Supplier<Evaluator> evaluatorProvider) {
            return this.withKeyword(keyword, (SchemaParsingContext ctx, JsonNode jsonNode) -> (Evaluator)evaluatorProvider.get());
        }

        public EvaluatorFactory build() {
            return new MapEvaluatorFactory(this.providers);
        }
    }
}

