/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.ValidatingEvaluator;

class MaxLengthEvaluator
implements ValidatingEvaluator {
    private final int maxLength;

    MaxLengthEvaluator(JsonNode node) {
        if (!node.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.maxLength = node.asInteger().intValueExact();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isString()) {
            return Evaluator.Result.success();
        }
        String string = node.asString();
        if (string.codePointCount(0, string.length()) <= this.maxLength) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(String.format("\"%s\" is longer than %d characters", string, this.maxLength));
    }
}

