/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.AnnotationTree;
import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.Error;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.OptionalUtil;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaNotFoundException;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public final class EvaluationContext {
    private final JsonNodeFactory jsonNodeFactory;
    private final JsonParser jsonParser;
    private final SchemaRegistry schemaRegistry;
    private final SchemaResolver schemaResolver;
    private final Set<String> activeVocabularies;
    private final boolean disabledSchemaValidation;
    private final Deque<URI> dynamicScope = new ArrayDeque<URI>();
    private final Deque<RefStackItem> refStack = new ArrayDeque<RefStackItem>();
    private final LinkedList<String> evaluationStack = new LinkedList();
    private final AnnotationTree annotationTree = new AnnotationTree();
    private final List<Error> errors = new ArrayList<Error>();

    EvaluationContext(JsonNodeFactory jsonNodeFactory, JsonParser jsonParser, SchemaRegistry schemaRegistry, SchemaResolver schemaResolver, Set<String> activeVocabularies, boolean disabledSchemaValidation) {
        this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
        this.jsonParser = Objects.requireNonNull(jsonParser);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
        this.activeVocabularies = Objects.requireNonNull(activeVocabularies);
        this.disabledSchemaValidation = disabledSchemaValidation;
        this.evaluationStack.push("");
    }

    public boolean resolveRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveRefAndValidate(CompoundUri.fromString(schemaRef), node);
    }

    boolean resolveRefAndValidate(CompoundUri compoundUri, JsonNode node) {
        return this.resolveSchema(compoundUri).map(schema -> this.validateAgainstRefSchema((Schema)schema, node)).orElseThrow(() -> new SchemaNotFoundException(compoundUri));
    }

    public boolean resolveDynamicRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveDynamicRefAndValidate(CompoundUri.fromString(schemaRef), node);
    }

    boolean resolveDynamicRefAndValidate(CompoundUri compoundUri, JsonNode node) {
        return this.resolveDynamicSchema(compoundUri).map(schema -> this.validateAgainstRefSchema((Schema)schema, node)).orElseThrow(() -> new SchemaNotFoundException(compoundUri));
    }

    public boolean resolveRecursiveRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveRecursiveSchema().map(schema -> this.validateAgainstRefSchema((Schema)schema, node)).orElseThrow(() -> new SchemaNotFoundException(CompoundUri.fromString(schemaRef)));
    }

    public boolean resolveInternalRefAndValidate(String schemaRef, JsonNode node) {
        return this.resolveInternalRefAndValidate(CompoundUri.fromString(schemaRef), node);
    }

    boolean resolveInternalRefAndValidate(CompoundUri compoundUri, JsonNode node) {
        return Optional.ofNullable(this.schemaRegistry.get(compoundUri)).map(schema -> this.validateAgainstSchema((Schema)schema, node)).orElseThrow(() -> new SchemaNotFoundException(compoundUri));
    }

    List<Error> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    <T> Optional<T> getSiblingAnnotation(String sibling, String instanceLocation, Class<T> annotationType) {
        return this.getSiblingAnnotation(sibling, instanceLocation).filter(annotationType::isInstance).map(annotationType::cast);
    }

    Optional<Object> getSiblingAnnotation(String sibling, String instanceLocation) {
        return this.annotationTree.getNode((String)this.evaluationStack.get((int)1)).annotations.stream().filter(item -> instanceLocation.equals(item.getInstanceLocation())).filter(item -> sibling.equals(item.getKeyword())).map(Annotation::getAnnotation).findFirst();
    }

    AnnotationTree getAnnotationTree() {
        return this.annotationTree;
    }

    Stream<Annotation> getAnnotationsFromParent() {
        String parentPath = this.evaluationStack.get(1);
        String correctedParentPath = UriUtil.getJsonPointerParent(this.evaluationStack.element());
        return this.annotationTree.getNode(parentPath).stream().filter(item -> item.getEvaluationPath().startsWith(correctedParentPath));
    }

    boolean validateAgainstSchema(Schema schema, JsonNode node) {
        boolean valid;
        boolean outOfDynamicScope;
        boolean bl = outOfDynamicScope = !schema.getParentUri().equals(this.dynamicScope.peek());
        if (outOfDynamicScope) {
            this.dynamicScope.push(schema.getParentUri());
        }
        String parentSchemaLocation = this.evaluationStack.size() > 1 ? this.evaluationStack.get(1) : null;
        AnnotationTree.Node treeNode = this.annotationTree.createIfAbsent(parentSchemaLocation, this.evaluationStack.element());
        int nodesBefore = treeNode.nodes.size();
        int annotationsBefore = treeNode.annotations.size();
        Stream<Object> evaluatorStream = schema.getEvaluators().stream();
        if (!this.disabledSchemaValidation) {
            evaluatorStream = evaluatorStream.filter(ev -> ev.getVocabularies().stream().anyMatch(this.activeVocabularies::contains) || ev.getVocabularies().isEmpty());
        }
        if (!(valid = evaluatorStream.reduce(true, (validAcc, evaluator) -> {
            String evaluationPath = this.resolveEvaluationPath((EvaluatorWrapper)evaluator);
            this.evaluationStack.push(evaluationPath);
            int errorsBefore = this.errors.size();
            Evaluator.Result result = evaluator.evaluate(this, node);
            if (result.isValid()) {
                this.errors.subList(errorsBefore, this.errors.size()).clear();
                Annotation annotation = new Annotation(evaluationPath, schema.getSchemaLocation(), node.getJsonPointer(), evaluator.getKeyword(), result.getAnnotation());
                treeNode.annotations.add(annotation);
            } else {
                this.errors.add(new Error(evaluationPath, schema.getSchemaLocation(), node.getJsonPointer(), evaluator.getKeyword(), result.getError()));
            }
            this.evaluationStack.pop();
            return validAcc != false && result.isValid();
        }, (v1, v2) -> v1 != false && v2 != false).booleanValue())) {
            treeNode.nodes.subList(nodesBefore, treeNode.nodes.size()).clear();
            treeNode.annotations.subList(annotationsBefore, treeNode.annotations.size()).clear();
        }
        if (outOfDynamicScope) {
            this.dynamicScope.pop();
        }
        return valid;
    }

    private boolean validateAgainstRefSchema(Schema schema, JsonNode node) {
        this.refStack.push(new RefStackItem(schema.getSchemaLocationFragment(), this.evaluationStack.peek()));
        boolean valid = this.validateAgainstSchema(schema, node);
        this.refStack.pop();
        return valid;
    }

    private Optional<Schema> resolveSchema(CompoundUri compoundUri) {
        CompoundUri resolvedUri = UriUtil.resolveUri(this.dynamicScope.element(), compoundUri);
        return OptionalUtil.firstPresent(() -> Optional.ofNullable(this.schemaRegistry.get(resolvedUri)), () -> Optional.ofNullable(this.schemaRegistry.getDynamic(resolvedUri)), () -> this.resolveExternalSchema(compoundUri, resolvedUri));
    }

    private Optional<Schema> resolveDynamicSchema(CompoundUri compoundUri) {
        CompoundUri resolvedUri = UriUtil.resolveUri(this.dynamicScope.element(), compoundUri);
        Schema staticSchema = this.schemaRegistry.get(resolvedUri);
        if (staticSchema != null) {
            return Optional.of(staticSchema);
        }
        Iterator<URI> it = this.dynamicScope.descendingIterator();
        while (it.hasNext()) {
            Schema schema = this.schemaRegistry.getDynamic(new CompoundUri(it.next(), resolvedUri.fragment));
            if (schema == null) continue;
            return Optional.of(schema);
        }
        return Optional.empty();
    }

    private Optional<Schema> resolveRecursiveSchema() {
        Schema schema = this.schemaRegistry.get(this.dynamicScope.element());
        for (URI uri : this.dynamicScope) {
            Schema recursedSchema = this.schemaRegistry.getDynamic(uri);
            if (recursedSchema == null) {
                return Optional.of(schema);
            }
            schema = recursedSchema;
        }
        return Optional.of(schema);
    }

    private String resolveEvaluationPath(EvaluatorWrapper evaluator) {
        if (this.refStack.isEmpty()) {
            return evaluator.getKeywordPath();
        }
        RefStackItem refItem = this.refStack.peek();
        String evaluationPathPart = evaluator.getKeywordPath().substring(refItem.schemaLocation.length());
        return refItem.evaluationPath + evaluationPathPart;
    }

    private Optional<Schema> resolveExternalSchema(CompoundUri originalRef, CompoundUri resolvedUri) {
        if (this.schemaRegistry.get(resolvedUri.uri) != null) {
            return Optional.empty();
        }
        return this.schemaResolver.resolve(resolvedUri.uri.toString()).toJsonNode(this.jsonNodeFactory).flatMap(node -> {
            this.jsonParser.parseRootSchema(resolvedUri.uri, (JsonNode)node);
            return this.resolveSchema(originalRef);
        });
    }

    private static class RefStackItem {
        private final String schemaLocation;
        private final String evaluationPath;

        private RefStackItem(String schemaLocation, String evaluationPath) {
            this.schemaLocation = schemaLocation;
            this.evaluationPath = evaluationPath;
        }
    }
}

