/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.providers.SimpleJsonNodeFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public final class JsonSmartNode
implements JsonNode {
    private final Factory factory;
    private final Object node;
    private final String jsonPointer;
    private final SimpleType nodeType;

    private JsonSmartNode(Factory factory, Object node, String jsonPointer) {
        this.factory = Objects.requireNonNull(factory);
        this.node = node;
        this.jsonPointer = Objects.requireNonNull(jsonPointer);
        this.nodeType = factory.computeNodeType(this.node);
    }

    public JsonSmartNode(Factory factory, Object node) {
        this(factory, node, "");
    }

    @Override
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Override
    public SimpleType getNodeType() {
        return this.nodeType;
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.node;
    }

    @Override
    public String asString() {
        return String.valueOf(this.node);
    }

    @Override
    public BigInteger asInteger() {
        if (this.node instanceof BigInteger) {
            return (BigInteger)this.node;
        }
        if (this.node instanceof BigDecimal) {
            return ((BigDecimal)this.node).toBigInteger();
        }
        return BigInteger.valueOf(((Number)this.node).longValue());
    }

    @Override
    public BigDecimal asNumber() {
        if (this.node instanceof BigDecimal) {
            return (BigDecimal)this.node;
        }
        if (this.node instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.node);
        }
        if (this.node instanceof Double) {
            return BigDecimal.valueOf((Double)this.node);
        }
        return BigDecimal.valueOf(((Number)this.node).longValue());
    }

    @Override
    public List<JsonNode> asArray() {
        JSONArray jsonArray = (JSONArray)this.node;
        ArrayList<JsonNode> result = new ArrayList<JsonNode>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            result.add(new JsonSmartNode(this.factory, jsonArray.get(i), this.jsonPointer + "/" + i));
        }
        return result;
    }

    @Override
    public Map<String, JsonNode> asObject() {
        Set objectMap = ((JSONObject)this.node).entrySet();
        HashMap<String, JsonNode> result = new HashMap<String, JsonNode>(objectMap.size());
        for (Map.Entry entry : objectMap) {
            result.put((String)entry.getKey(), new JsonSmartNode(this.factory, entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer((String)entry.getKey())));
        }
        return result;
    }

    public static final class Factory
    extends SimpleJsonNodeFactory {
        private final JSONParser parser;

        public Factory() {
            this(new JSONParser(4032));
        }

        public Factory(JSONParser parser) {
            this.parser = parser;
        }

        @Override
        public JsonSmartNode wrap(Object node) {
            if (this.isLiteral(node) || this.isArray(node) || this.isObject(node)) {
                return new JsonSmartNode(this, node);
            }
            if (node instanceof JsonSmartNode) {
                return (JsonSmartNode)node;
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of net.minidev.json.JSONObject, net.minidev.json.JSONArray or simple literal");
        }

        @Override
        public JsonSmartNode create(String rawJson) {
            try {
                return new JsonSmartNode(this, this.parser.parse(rawJson));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        boolean isNull(Object node) {
            return node == null;
        }

        @Override
        boolean isArray(Object node) {
            return node instanceof JSONArray;
        }

        @Override
        boolean isObject(Object node) {
            return node instanceof JSONObject;
        }
    }
}

