/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.providers.SimpleJsonNodeFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

public final class JettisonNode
implements JsonNode {
    private final Factory factory;
    private final Object node;
    private final String jsonPointer;
    private final SimpleType nodeType;

    private JettisonNode(Factory factory, Object node, String jsonPointer) {
        this.factory = Objects.requireNonNull(factory);
        this.node = Objects.requireNonNull(node);
        this.jsonPointer = Objects.requireNonNull(jsonPointer);
        this.nodeType = factory.computeNodeType(node);
    }

    public JettisonNode(Factory factory, Object node) {
        this(factory, node, "");
    }

    @Override
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Override
    public SimpleType getNodeType() {
        return this.nodeType;
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.node;
    }

    @Override
    public String asString() {
        if (this.factory.isNull(this.node)) {
            return "null";
        }
        return this.node.toString();
    }

    @Override
    public BigInteger asInteger() {
        if (this.node instanceof BigDecimal) {
            return ((BigDecimal)this.node).toBigInteger();
        }
        return BigInteger.valueOf(((Number)this.node).longValue());
    }

    @Override
    public BigDecimal asNumber() {
        if (this.node instanceof BigDecimal) {
            return (BigDecimal)this.node;
        }
        return BigDecimal.valueOf(((Number)this.node).longValue());
    }

    @Override
    public List<JsonNode> asArray() {
        ArrayList<JsonNode> elements = new ArrayList<JsonNode>();
        JSONArray arrayNode = (JSONArray)this.node;
        for (int i = 0; i < arrayNode.length(); ++i) {
            elements.add(new JettisonNode(this.factory, arrayNode.opt(i), this.jsonPointer + "/" + elements.size()));
        }
        return elements;
    }

    @Override
    public Map<String, JsonNode> asObject() {
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
        JSONObject jsonObject = (JSONObject)this.node;
        Iterator iterator = jsonObject.toMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            map.put(entry.getKey().toString(), new JettisonNode(this.factory, entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer(entry.getKey().toString())));
        }
        return map;
    }

    public static final class Factory
    extends SimpleJsonNodeFactory {
        @Override
        public JsonNode wrap(Object node) {
            if (this.isLiteral(node) || this.isArray(node) || this.isObject(node)) {
                return new JettisonNode(this, node);
            }
            if (node instanceof JettisonNode) {
                return (JettisonNode)node;
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of org.codehaus.jettison.json.JSONObject, org.codehaus.jettison.json.JSONArray or simple literal");
        }

        @Override
        public JsonNode create(String rawJson) {
            try {
                return new JettisonNode(this, new BigDecimalTokener(rawJson).nextValue());
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        boolean isNull(Object node) {
            return JSONObject.NULL.equals(node) || JSONObject.EXPLICIT_NULL.equals(node);
        }

        @Override
        boolean isArray(Object node) {
            return node instanceof JSONArray;
        }

        @Override
        boolean isObject(Object node) {
            return node instanceof JSONObject;
        }
    }

    static final class BigDecimalTokener
    extends JSONTokener {
        BigDecimalTokener(String s) {
            super(s);
            this.useBigDecimal = true;
        }
    }
}

