/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.EvaluationItem;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.UriUtil;
import dev.harrel.jsonschema.Vocabulary;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class UnevaluatedItemsEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;
    private final String parentPath;

    UnevaluatedItemsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
        this.parentPath = UriUtil.getJsonPointerParent(this.schemaRef.fragment);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.UNEVALUATED_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        Set evaluatedInstances = ctx.getAnnotationsFromParent(this.parentPath).map(EvaluationItem::getInstanceLocation).collect(Collectors.toSet());
        List array = node.asArray().stream().filter(arrayNode -> !evaluatedInstances.contains(arrayNode.getJsonPointer())).collect(Collectors.toList());
        boolean valid = array.stream().filter(arrayNode -> ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)arrayNode)).count() == (long)array.size();
        return valid ? Evaluator.Result.success() : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 30;
    }
}

