/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class PropertiesEvaluator
implements Evaluator {
    private final Map<String, CompoundUri> schemaRefs;

    PropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        HashMap<String, CompoundUri> uris = new HashMap<String, CompoundUri>();
        for (Map.Entry<String, JsonNode> entry : node.asObject().entrySet()) {
            uris.put(entry.getKey(), ctx.getCompoundUri(entry.getValue()));
        }
        this.schemaRefs = Collections.unmodifiableMap(uris);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        Map<String, JsonNode> filtered = node.asObject().entrySet().stream().filter(e -> this.schemaRefs.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        boolean valid = filtered.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<CompoundUri, JsonNode>(this.schemaRefs.get(e.getKey()), (JsonNode)e.getValue())).filter(e -> ctx.resolveInternalRefAndValidate((CompoundUri)e.getKey(), (JsonNode)e.getValue())).count() == (long)filtered.size();
        return valid ? Evaluator.Result.success(Collections.unmodifiableSet(filtered.keySet())) : Evaluator.Result.failure();
    }
}

