/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class PatternPropertiesEvaluator
implements Evaluator {
    private final Map<Pattern, CompoundUri> schemasByPatterns;

    PatternPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException();
        }
        this.schemasByPatterns = node.asObject().entrySet().stream().collect(Collectors.toMap(e -> Pattern.compile((String)e.getKey()), e -> ctx.getCompoundUri((JsonNode)e.getValue())));
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        boolean valid = true;
        HashSet<String> processed = new HashSet<String>();
        for (Map.Entry<String, JsonNode> entry : node.asObject().entrySet()) {
            List schemaRefs = Collections.unmodifiableList(this.schemasByPatterns.entrySet().stream().filter(e -> ((Pattern)e.getKey()).matcher((CharSequence)entry.getKey()).find()).map(Map.Entry::getValue).collect(Collectors.toList()));
            if (!schemaRefs.isEmpty()) {
                processed.add(entry.getKey());
            }
            valid = schemaRefs.stream().filter(ref -> ctx.resolveInternalRefAndValidate((CompoundUri)ref, (JsonNode)entry.getValue())).count() == (long)schemaRefs.size() && valid;
        }
        return valid ? Evaluator.Result.success(Collections.unmodifiableSet(processed)) : Evaluator.Result.failure();
    }
}

