/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.InvalidSchemaException;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.MetaSchemaResolvingException;
import dev.harrel.jsonschema.OptionalUtil;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import dev.harrel.jsonschema.UriUtil;
import dev.harrel.jsonschema.Validator;
import dev.harrel.jsonschema.VocabularyException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

interface MetaSchemaValidator {
    public Set<String> validateSchema(JsonParser var1, URI var2, String var3, JsonNode var4);

    public Set<String> determineActiveVocabularies(Map<String, Boolean> var1);

    public static final class DefaultMetaSchemaValidator
    implements MetaSchemaValidator {
        private final Dialect dialect;
        private final JsonNodeFactory jsonNodeFactory;
        private final SchemaRegistry schemaRegistry;
        private final SchemaResolver schemaResolver;

        DefaultMetaSchemaValidator(Dialect dialect, JsonNodeFactory jsonNodeFactory, SchemaRegistry schemaRegistry, SchemaResolver schemaResolver) {
            this.dialect = Objects.requireNonNull(dialect);
            this.jsonNodeFactory = Objects.requireNonNull(jsonNodeFactory);
            this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
            this.schemaResolver = Objects.requireNonNull(schemaResolver);
        }

        @Override
        public Set<String> validateSchema(JsonParser jsonParser, URI metaSchemaUri, String schemaUri, JsonNode node) {
            Objects.requireNonNull(metaSchemaUri);
            Schema schema = this.resolveMetaSchema(jsonParser, metaSchemaUri);
            EvaluationContext ctx = new EvaluationContext(this.jsonNodeFactory, jsonParser, this.schemaRegistry, this.schemaResolver, schema.getActiveVocabularies());
            if (!ctx.validateAgainstSchema(schema, node)) {
                throw new InvalidSchemaException(String.format("Schema [%s] failed to validate against meta-schema [%s]", schemaUri, metaSchemaUri), new Validator.Result(false, ctx).getErrors());
            }
            return this.determineActiveVocabularies(schema.getVocabulariesObject());
        }

        @Override
        public Set<String> determineActiveVocabularies(Map<String, Boolean> vocabulariesObject) {
            List missingRequiredVocabularies = this.dialect.getRequiredVocabularies().stream().filter(vocab -> vocabulariesObject.getOrDefault(vocab, false) == false).collect(Collectors.toList());
            if (!missingRequiredVocabularies.isEmpty()) {
                throw new VocabularyException(String.format("Required vocabularies [%s] were missing or marked optional in $vocabulary object", missingRequiredVocabularies));
            }
            List unsupportedRequiredVocabularies = vocabulariesObject.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).filter(vocab -> !this.dialect.getSupportedVocabularies().contains(vocab)).collect(Collectors.toList());
            if (!unsupportedRequiredVocabularies.isEmpty()) {
                throw new VocabularyException(String.format("Following vocabularies [%s] are required but not supported", unsupportedRequiredVocabularies));
            }
            return vocabulariesObject.keySet();
        }

        private Schema resolveMetaSchema(JsonParser jsonParser, URI uri) {
            return OptionalUtil.firstPresent(() -> Optional.ofNullable(this.schemaRegistry.get(uri)), () -> Optional.ofNullable(this.schemaRegistry.getDynamic(uri))).orElseGet(() -> this.resolveExternalSchema(jsonParser, uri));
        }

        private Schema resolveExternalSchema(JsonParser jsonParser, URI uri) {
            URI baseUri = UriUtil.getUriWithoutFragment(uri);
            if (this.schemaRegistry.get(baseUri) != null) {
                throw MetaSchemaResolvingException.resolvingFailure(uri.toString());
            }
            SchemaResolver.Result result = this.schemaResolver.resolve(baseUri.toString());
            if (result.isEmpty()) {
                throw MetaSchemaResolvingException.resolvingFailure(uri.toString());
            }
            try {
                result.toJsonNode(this.jsonNodeFactory).ifPresent(node -> jsonParser.parseRootSchema(baseUri, (JsonNode)node));
            }
            catch (Exception e) {
                throw MetaSchemaResolvingException.parsingFailure(uri.toString(), e);
            }
            return this.resolveMetaSchema(jsonParser, uri);
        }
    }

    public static final class NoOpMetaSchemaValidator
    implements MetaSchemaValidator {
        private final Set<String> activeVocabularies;

        public NoOpMetaSchemaValidator(Set<String> activeVocabularies) {
            this.activeVocabularies = activeVocabularies;
        }

        @Override
        public Set<String> validateSchema(JsonParser jsonParser, URI metaSchemaUri, String schemaUri, JsonNode node) {
            return this.activeVocabularies;
        }

        @Override
        public Set<String> determineActiveVocabularies(Map<String, Boolean> vocabulariesObject) {
            return this.activeVocabularies;
        }
    }
}

