/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SimpleType;
import java.math.BigDecimal;
import java.math.BigInteger;

abstract class SimpleJsonNodeFactory
implements JsonNodeFactory {
    SimpleJsonNodeFactory() {
    }

    boolean isLiteral(Object node) {
        return this.isNull(node) || this.isBoolean(node) || this.isString(node) || this.isInteger(node) || this.isDecimal(node);
    }

    boolean isBoolean(Object node) {
        return node instanceof Boolean;
    }

    boolean isString(Object node) {
        return node instanceof Character || node instanceof String || node instanceof Enum;
    }

    boolean isInteger(Object node) {
        return node instanceof Integer || node instanceof Long || node instanceof BigInteger;
    }

    boolean isDecimal(Object node) {
        return node instanceof Double || node instanceof BigDecimal;
    }

    abstract boolean isNull(Object var1);

    abstract boolean isArray(Object var1);

    abstract boolean isObject(Object var1);

    SimpleType computeNodeType(Object node) {
        if (this.isNull(node)) {
            return SimpleType.NULL;
        }
        if (this.isBoolean(node)) {
            return SimpleType.BOOLEAN;
        }
        if (this.isString(node)) {
            return SimpleType.STRING;
        }
        if (this.isDecimal(node)) {
            if (node instanceof BigDecimal && ((BigDecimal)node).stripTrailingZeros().scale() <= 0) {
                return SimpleType.INTEGER;
            }
            if (node instanceof Double && ((Number)node).doubleValue() == Math.rint(((Number)node).doubleValue())) {
                return SimpleType.INTEGER;
            }
            return SimpleType.NUMBER;
        }
        if (this.isInteger(node)) {
            return SimpleType.INTEGER;
        }
        if (this.isArray(node)) {
            return SimpleType.ARRAY;
        }
        if (this.isObject(node)) {
            return SimpleType.OBJECT;
        }
        throw new IllegalArgumentException("Cannot assign type to node of class=" + node.getClass().getName());
    }
}

