/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.providers.SimpleJsonNodeFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class OrgJsonNode
implements JsonNode {
    private final Factory factory;
    private final Object node;
    private final String jsonPointer;
    private final SimpleType nodeType;

    private OrgJsonNode(Factory factory, Object node, String jsonPointer) {
        this.factory = Objects.requireNonNull(factory);
        this.node = Objects.requireNonNull(node);
        this.jsonPointer = Objects.requireNonNull(jsonPointer);
        this.nodeType = factory.computeNodeType(node);
    }

    public OrgJsonNode(Factory factory, Object node) {
        this(factory, node, "");
    }

    @Override
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Override
    public SimpleType getNodeType() {
        return this.nodeType;
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.node;
    }

    @Override
    public String asString() {
        return this.node.toString();
    }

    @Override
    public BigInteger asInteger() {
        if (this.node instanceof BigInteger) {
            return (BigInteger)this.node;
        }
        if (this.node instanceof BigDecimal) {
            return ((BigDecimal)this.node).toBigInteger();
        }
        return BigInteger.valueOf(((Number)this.node).longValue());
    }

    @Override
    public BigDecimal asNumber() {
        if (this.node instanceof BigDecimal) {
            return (BigDecimal)this.node;
        }
        if (this.node instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.node);
        }
        if (this.node instanceof Double) {
            return BigDecimal.valueOf((Double)this.node);
        }
        return BigDecimal.valueOf(((Number)this.node).longValue());
    }

    @Override
    public List<JsonNode> asArray() {
        ArrayList<JsonNode> elements = new ArrayList<JsonNode>();
        for (Object o : (JSONArray)this.node) {
            elements.add(new OrgJsonNode(this.factory, o, this.jsonPointer + "/" + elements.size()));
        }
        return elements;
    }

    @Override
    public Map<String, JsonNode> asObject() {
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
        JSONObject jsonObject = (JSONObject)this.node;
        for (String key : jsonObject.keySet()) {
            map.put(key, new OrgJsonNode(this.factory, jsonObject.get(key), this.jsonPointer + "/" + key));
        }
        return map;
    }

    public static final class Factory
    extends SimpleJsonNodeFactory {
        @Override
        public JsonNode wrap(Object node) {
            if (this.isLiteral(node) || this.isArray(node) || this.isObject(node)) {
                return new OrgJsonNode(this, node);
            }
            if (node instanceof OrgJsonNode) {
                return (OrgJsonNode)node;
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of org.json.JSONObject, org.json.JSONArray or simple literal");
        }

        @Override
        public JsonNode create(String rawJson) {
            return new OrgJsonNode(this, new JSONTokener(rawJson).nextValue());
        }

        @Override
        boolean isNull(Object node) {
            return JSONObject.NULL.equals(node);
        }

        @Override
        boolean isArray(Object node) {
            return node instanceof JSONArray;
        }

        @Override
        boolean isObject(Object node) {
            return node instanceof JSONObject;
        }
    }
}

