/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

final class UriUtil {
    private UriUtil() {
    }

    static boolean hasNonEmptyFragment(URI uri) {
        return uri.getFragment() != null && !uri.getFragment().isEmpty();
    }

    static URI getUriWithoutFragment(URI uri) {
        if (uri.getFragment() == null) {
            return uri;
        }
        return UriUtil.getUriWithoutFragment(uri.toString());
    }

    static URI getUriWithoutFragment(String uri) {
        int fragmentIdx = uri.indexOf(35);
        if (fragmentIdx < 0) {
            return URI.create(uri);
        }
        return URI.create(uri.substring(0, fragmentIdx));
    }

    static String getJsonPointer(String uri) {
        int fragmentIdx = uri.indexOf(35);
        if (fragmentIdx < 0) {
            return "";
        }
        return uri.substring(fragmentIdx + 1);
    }

    static String getJsonPointerParent(String pointer) {
        return pointer.substring(0, pointer.lastIndexOf(47));
    }

    static CompoundUri resolveUri(URI baseUri, CompoundUri ref) {
        String fragment = UriUtil.decodeJsonPointer(ref.fragment);
        if (ref.uri.toString().isEmpty()) {
            return new CompoundUri(baseUri, fragment);
        }
        return new CompoundUri(baseUri.resolve(ref.uri), fragment);
    }

    static String decodeJsonPointer(String pointer) {
        return UriUtil.internalDecode(pointer).replace("~0", "~").replace("~1", "/");
    }

    private static String internalDecode(String url) {
        try {
            return URLDecoder.decode(url, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

