/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class AnyOfEvaluator
implements Evaluator {
    private final List<CompoundUri> refs;

    AnyOfEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.refs = Collections.unmodifiableList(node.asArray().stream().map(ctx::getCompoundUri).collect(Collectors.toList()));
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        boolean valid = this.refs.stream().filter(pointer -> ctx.resolveInternalRefAndValidate((CompoundUri)pointer, node)).count() > 0L;
        return valid ? Evaluator.Result.success() : Evaluator.Result.failure("Value does not match against any of the schemas");
    }
}

