/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluatorWrapper;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeUtil;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class SchemaRegistry {
    private State state = State.access$000();

    SchemaRegistry() {
    }

    State createSnapshot() {
        return this.state.copy();
    }

    void restoreSnapshot(State state) {
        this.state = state;
    }

    Schema get(String ref) {
        URI baseUri = UriUtil.getUriWithoutFragment(ref);
        String jsonPointer = UriUtil.getJsonPointer(ref);
        return this.get(baseUri, jsonPointer);
    }

    Schema get(URI baseUri) {
        return this.get(baseUri, "");
    }

    private Schema get(URI baseUri, String fragment) {
        Fragments fragments = this.state.getFragments(baseUri);
        return fragments.schemas.getOrDefault(fragment, (Schema)fragments.additionalSchemas.get(fragment));
    }

    Schema getDynamic(String ref) {
        URI baseUri = UriUtil.getUriWithoutFragment(ref);
        String jsonPointer = UriUtil.getJsonPointer(ref);
        Fragments fragments = this.state.getFragments(baseUri);
        return (Schema)fragments.dynamicSchemas.get(jsonPointer);
    }

    void registerAlias(URI originalUri, URI aliasUri) {
        Fragments originalFragments = this.state.getFragments(originalUri);
        this.state.fragments.put(aliasUri, originalFragments.readOnly());
    }

    void registerSchema(SchemaParsingContext ctx, JsonNode schemaNode, List<EvaluatorWrapper> evaluators, Set<String> activeVocabularies) {
        Schema schema = new Schema(ctx.getParentUri(), ctx.getAbsoluteUri(schemaNode), evaluators, activeVocabularies, ctx.getVocabulariesObject());
        this.state.getFragments(ctx.getBaseUri()).schemas.put(schemaNode.getJsonPointer(), schema);
        this.registerAnchorsIfPresent(ctx, schemaNode, schema);
    }

    void registerEmbeddedSchema(SchemaParsingContext ctx, URI id, JsonNode schemaNode, List<EvaluatorWrapper> evaluators, Set<String> activeVocabularies) {
        Fragments baseFragments = this.state.getFragments(ctx.getBaseUri());
        Fragments idFragments = this.state.getFragments(UriUtil.getUriWithoutFragment(id));
        baseFragments.schemas.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(schemaNode.getJsonPointer())).forEach(e -> {
            String newJsonPointer = ((String)e.getKey()).substring(schemaNode.getJsonPointer().length());
            idFragments.additionalSchemas.put(newJsonPointer, (Schema)e.getValue());
        });
        Schema identifiableSchema = new Schema(ctx.getParentUri(), ctx.getAbsoluteUri(schemaNode), evaluators, activeVocabularies, ctx.getVocabulariesObject());
        idFragments.schemas.put("", identifiableSchema);
        baseFragments.schemas.put(schemaNode.getJsonPointer(), identifiableSchema);
        this.registerAnchorsIfPresent(ctx, schemaNode, identifiableSchema);
    }

    private void registerAnchorsIfPresent(SchemaParsingContext ctx, JsonNode schemaNode, Schema schema) {
        if (!schemaNode.isObject()) {
            return;
        }
        Map<String, JsonNode> objectMap = schemaNode.asObject();
        Fragments fragments = this.state.getFragments(ctx.getParentUri());
        JsonNodeUtil.getStringField(objectMap, "$anchor").ifPresent(anchorString -> fragments.additionalSchemas.put(anchorString, schema));
        JsonNodeUtil.getStringField(objectMap, "$dynamicAnchor").ifPresent(anchorString -> fragments.dynamicSchemas.put(anchorString, schema));
        JsonNodeUtil.getBooleanField(objectMap, "$recursiveAnchor").filter(anchor -> anchor).ifPresent(anchorString -> fragments.dynamicSchemas.put("", schema));
    }

    static final class State {
        private final Map<URI, Fragments> fragments;

        private State(Map<URI, Fragments> fragments) {
            this.fragments = fragments;
        }

        private Fragments getFragments(URI uri) {
            return this.fragments.computeIfAbsent(uri, key -> Fragments.empty());
        }

        private State copy() {
            Map<URI, Fragments> copiedMap = this.fragments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Fragments)e.getValue()).copy()));
            return new State(copiedMap);
        }

        private static State empty() {
            return new State(new HashMap<URI, Fragments>());
        }

        static /* synthetic */ State access$000() {
            return State.empty();
        }
    }

    private static final class Fragments {
        private final Map<String, Schema> schemas;
        private final Map<String, Schema> additionalSchemas;
        private final Map<String, Schema> dynamicSchemas;

        private Fragments(Map<String, Schema> schemas, Map<String, Schema> additionalSchemas, Map<String, Schema> dynamicSchemas) {
            this.schemas = schemas;
            this.additionalSchemas = additionalSchemas;
            this.dynamicSchemas = dynamicSchemas;
        }

        private Fragments copy() {
            return new Fragments(new HashMap<String, Schema>(this.schemas), new HashMap<String, Schema>(this.additionalSchemas), new HashMap<String, Schema>(this.dynamicSchemas));
        }

        private Fragments readOnly() {
            return new Fragments(Collections.unmodifiableMap(this.schemas), Collections.unmodifiableMap(this.additionalSchemas), Collections.unmodifiableMap(this.dynamicSchemas));
        }

        private static Fragments empty() {
            return new Fragments(new HashMap<String, Schema>(), new HashMap<String, Schema>(), new HashMap<String, Schema>());
        }
    }
}

