/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.StringNode;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Map;
import java.util.Set;

class PropertyNamesEvaluator
implements Evaluator {
    private final String schemaRef;

    PropertyNamesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getAbsoluteUri(node);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        Map<String, JsonNode> object = node.asObject();
        boolean valid = object.keySet().stream().filter(propName -> ctx.resolveInternalRefAndValidate(this.schemaRef, new StringNode((String)propName, node.getJsonPointer()))).count() == (long)object.size();
        return valid ? Evaluator.Result.success() : Evaluator.Result.failure();
    }
}

