/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class Items2019Evaluator
implements Evaluator {
    private final String schemaRef;
    private final List<String> schemaRefs;

    Items2019Evaluator(SchemaParsingContext ctx, JsonNode node) {
        if (node.isObject() || node.isBoolean()) {
            this.schemaRef = ctx.getAbsoluteUri(node);
            this.schemaRefs = null;
        } else if (node.isArray()) {
            this.schemaRef = null;
            this.schemaRefs = Collections.unmodifiableList(node.asArray().stream().map(ctx::getAbsoluteUri).collect(Collectors.toList()));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        List<JsonNode> array = node.asArray();
        if (this.schemaRef != null) {
            boolean valid = array.stream().filter(element -> ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)element)).count() == (long)array.size();
            return valid ? Evaluator.Result.success(true) : Evaluator.Result.failure();
        }
        int size = Math.min(this.schemaRefs.size(), array.size());
        boolean valid = IntStream.range(0, size).boxed().filter(idx -> ctx.resolveInternalRefAndValidate(this.schemaRefs.get((int)idx), (JsonNode)array.get((int)idx))).count() == (long)size;
        return valid ? Evaluator.Result.success(this.schemaRefs.size()) : Evaluator.Result.failure();
    }
}

