/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.Vocabulary;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class ContainsEvaluator
implements Evaluator {
    private final String schemaRef;
    private final boolean minContainsZero;

    ContainsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getAbsoluteUri(node);
        this.minContainsZero = Optional.ofNullable(ctx.getCurrentSchemaObject().get("minContains")).map(JsonNode::asInteger).map(BigInteger::intValueExact).map(min -> min == 0).orElse(false);
    }

    @Override
    public Set<String> getVocabularies() {
        return Vocabulary.APPLICATOR_VOCABULARY;
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        List<JsonNode> array = node.asArray();
        List indices = Collections.unmodifiableList(IntStream.range(0, array.size()).filter(i -> ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)array.get(i))).boxed().collect(Collectors.toList()));
        return this.minContainsZero || !indices.isEmpty() ? Evaluator.Result.success(indices) : Evaluator.Result.failure("Array contains no matching items");
    }
}

